!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ :: ѴؿΥƥ
!
!  2008/04/03  ݹ
!      2008/07/05  ʿ  ѹ
!
program wq_test_base

  use dc_message, only : MessageNotify
  use wq_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=8    ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=15          ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=2.0                ! Ⱦ

  real(8), dimension(0:im-1,1:jm,km)       ::  xyr_data
  real(8), parameter                 ::  eps = 1.0D-10
  real(8) :: pi

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','wq_test_base', &
                         'wq_module basic transformation functions tests') 

  call wq_Initial(im,jm,km,nm,lm,ra)

  !---- Y_1^* Υƥ ----
  xyr_data = sqrt(3.0D0)*sin(xyr_Lat)*xyr_Rad        ! r Y_1^0 
  if ( maxval(abs(xyr_wq(wq_xyr(xyr_data))-xyr_data)) > eps ) then
     write(6,*) maxval(abs(xyr_wq(wq_xyr(xyr_data))-xyr_data))
     call MessageNotify('E','Test of r Y_1^0',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of r Y_1^0', &
                     'transformation tests succeeded!') 

  xyr_data = sqrt(3.0D0/2)*cos(xyr_Lat)*cos(xyr_Lon)*xyr_Rad**3   ! r^3Y_1^1 

  if ( maxval(abs(xyr_wq(wq_xyr(xyr_data))-xyr_data)) > eps ) then
     call MessageNotify('E','Test of r^3 Y_1^1 ',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of r^3 Y_1^1', &
                     'transformation tests succeeded!') 

  xyr_data = -sqrt(3.0D0/2)*cos(xyr_Lat)*sin(xyr_Lon) * xyr_Rad**5  !r^5Y_1^{-1}

  if ( maxval(abs(xyr_wq(wq_xyr(xyr_data))-xyr_data)) > eps ) then
     call MessageNotify('E','Test of r^5 Y_1^-1',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of r^5 Y_1^-1', &
                     'transformation tests succeeded!') 

  !---- Y_2^* Υƥ ----
  !r^2 Y_2^0
  xyr_data = sqrt(5.0D0)*(3.0/2*sin(xyr_Lat)**2-1/2.0) * xyr_Rad**2

  if ( maxval(abs(xyr_wq(wq_xyr(xyr_data))-xyr_data)) > eps ) then
     call MessageNotify('E','Test of r^2 Y_2^0',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of r^2 Y_2^0', &
                     'transformation tests succeeded!') 

  !r^4 Y_2^1 
  xyr_data = sqrt(5.0D0/6)*3.0*sin(xyr_Lat)*cos(xyr_Lat)*cos(xyr_Lon) &
            * xyr_Rad**4

  if ( maxval(abs(xyr_wq(wq_xyr(xyr_data))-xyr_data)) > eps ) then
     call MessageNotify('E','Test of r^4 Y_2^1',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of r^4 Y_2^1', &
                     'transformation tests succeeded!') 

  !r^6 Y_2^-2
  xyr_data = -sqrt(5.0D0/24)*3.0*cos(xyr_Lat)**2*sin(2*xyr_Lon)* xyr_Rad**6

  if ( maxval(abs(xyr_wq(wq_xyr(xyr_data))-xyr_data)) > eps ) then
     call MessageNotify('E','Test of r^6 Y_2^-2 ',&
          'Spectral and inverse transorms error too large') 
  endif
  call MessageNotify('M','Test of r^6 Y_2^-2', &
                     'transformation tests succeeded!') 

end program wq_test_base
