!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  at_module ƥȥץ
!      1 
!
!  2002/11/19  ݹ
!      2007/10/25  ݹ  顼åɲ
!
program at_test_boundaries2d

  use dc_message, only : MessageNotify
  use at_module
  implicit none

  integer, parameter :: im=8, km=8, nm=2
  real(8), parameter :: xmin=-1.0D0, xmax=1.0D0

  real(8), dimension(nm,0:im) :: ag_a
  real(8), dimension(nm,0:im) :: ag_dadx
  real(8), dimension(nm,0:km) :: at_a
  real(8), dimension(nm,2)    :: values

  real(8), parameter    :: eps=1.0D-10                 ! Ƹ

  values(1,:) = (/0,0/)
  values(2,:) = (/1,-2/)

  call at_initial(im,km,xmin,xmax)

  ag_a(1,:) = sin(g_X)
  ag_a(2,:) = cos(g_X)
  at_a = at_ag(ag_a)

!----- at_BoundariesGrid_DD ------
  write(6,*) 'Test of at_BoundariesGrid_DD...'
  call at_BoundariesGrid_DD(at_a,values)
  ag_a = ag_at(at_a)
  if ( maxval(abs(ag_a(:,0)-values(:,1))) > eps .OR. &
       maxval(abs(ag_a(:,im)-values(:,2))) > eps )then
     call MessageNotify('E','Test of at_BoundariesGrid_DD', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesGrid_DD', &
       'Test of at_BoundariesGrid_DD suceeded!')
  
!----- at_BoundariesGrid_DN ------
  write(6,*) 'Test of at_BoundariesGrid_DN...'
  call at_BoundariesGrid_DN(at_a,values)
  ag_a = ag_at(at_a)
  ag_dadx = ag_at(at_Dx_at(at_ag(ag_a)))
  if ( maxval(abs(ag_a(:,0)-values(:,1))) > eps .OR. &
       maxval(abs(ag_dadx(:,im)-values(:,2)))> eps )then
     call MessageNotify('E','Test of at_BoundariesGrid_DN', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesGrid_DN', &
       'Test of at_BoundariesGrid_DN suceeded!')

!----- at_BoundariesGrid_ND ------
  write(6,*) 'Test of at_BoundariesGrid_ND...'
  call at_BoundariesGrid_ND(at_a,values)
  ag_a = ag_at(at_a)
  ag_dadx = ag_at(at_Dx_at(at_ag(ag_a)))
  if ( maxval(abs(ag_dadx(:,0)-values(:,1))) > eps .OR. &
       maxval(abs(ag_a(:,im)-values(:,2))) > eps )then
     call MessageNotify('E','Test of at_BoundariesGrid_ND', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesGrid_ND', &
       'Test of at_BoundariesGrid_ND suceeded!')

!----- at_BoundariesGrid_NN ------
  write(6,*) 'Test of at_BoundariesGrid_NN...'
  call at_BoundariesGrid_NN(at_a,values)
  ag_a = ag_at(at_a)
  ag_dadx = ag_at(at_Dx_at(at_ag(ag_a)))
  if ( maxval(abs(ag_dadx(:,0)-values(:,1))) > eps .OR. &
       maxval(abs(ag_dadx(:,im)-values(:,2))) > eps )then
     call MessageNotify('E','Test of at_BoundariesGrid_NN', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesGrid_NN', &
       'Test of at_BoundariesGrid_NN suceeded!')

!----- at_BoundariesTau_DD ------
  write(6,*) 'Test of at_BoundariesTau_DD...'
  call at_BoundariesTau_DD(at_a,values)
  ag_a = ag_at(at_a)
  if ( maxval(abs(ag_a(:,0)-values(:,1))) > eps .OR. &
       maxval(abs(ag_a(:,im)-values(:,2))) > eps )then
     call MessageNotify('E','Test of at_BoundariesTau_DD', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesTau_DD', &
       'Test of at_BoundariesTau_DD suceeded!')
  
!----- at_BoundariesTau_DN ------
  write(6,*) 'Test of at_BoundariesTau_DN...'
  call at_BoundariesTau_DN(at_a,values)
  ag_a = ag_at(at_a)
  ag_dadx = ag_at(at_Dx_at(at_ag(ag_a)))
  if ( maxval(abs(ag_a(:,0)-values(:,1))) > eps .OR. &
       maxval(abs(ag_dadx(:,im)-values(:,2))) > eps )then
     call MessageNotify('E','Test of at_BoundariesTau_DN', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesTau_DN', &
       'Test of at_BoundariesTau_DN suceeded!')

!----- at_BoundariesTau_ND ------
  write(6,*) 'Test of at_BoundariesTau_ND...'
  call at_BoundariesTau_ND(at_a,values)
  ag_a = ag_at(at_a)
  ag_dadx = ag_at(at_Dx_at(at_ag(ag_a)))
  if ( maxval(abs(ag_dadx(:,0)-values(:,1))) > eps .OR. &
       maxval(abs(ag_a(:,im)-values(:,2))) > eps )then
     call MessageNotify('E','Test of at_BoundariesTau_ND', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesTau_ND', &
       'Test of at_BoundariesTau_ND suceeded!')

!----- at_BoundariesTau_NN ------
  write(6,*) 'Test of at_BoundariesTau_NN...'
  call at_BoundariesTau_NN(at_a,values)
  ag_a = ag_at(at_a)
  ag_dadx = ag_at(at_Dx_at(at_ag(ag_a)))
  if ( maxval(abs(ag_dadx(:,0)-values(:,1)))> eps .OR. &
       maxval(abs(ag_dadx(:,im)-values(:,2))) > eps )then
     call MessageNotify('E','Test of at_BoundariesTau_NN', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of at_BoundariesTau_NN', &
       'Test of at_BoundariesTau_NN suceeded!')

end program at_test_boundaries2d
