!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  aq_module ƥȥץ
!      1 
!
!  2008/04/02  ݹ
!
program aq_test_boundary_tau_2d

  use dc_message, only : MessageNotify
  use aq_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=4, km=7       ! ʻ, ȿ
  real(8), parameter :: ra=2               ! ΰ礭

  integer, parameter :: lm=2               ! ȿ

 !---- ɸѿʤ ----
  real(8), parameter :: alpha=0.5D0        ! Ÿ¿༰ѥ᥿  0 <  <= 1
  real(8), parameter :: beta= 1.0D0        ! Ÿ¿༰ѥ᥿  0 < 
  real(8), parameter :: gamma=2*alpha+beta ! Ÿ¿༰ѥ᥿ 

 !---- ѿ ----
  real(8), dimension(lm,im) :: ag_a
  real(8), dimension(lm,im) :: ag_dadx
  real(8), dimension(lm,0:km) :: aq_a
  real(8), dimension(lm)      :: value

  real(8), parameter    :: eps=1.0D-10                 ! Ƹ

  value(:) = (/2,1/)

  call aq_Initial(im,km,ra,alpha,beta,(/1,2/))

  ag_a(1,:) = sin(g_R)
  ag_a(2,:) = cos(g_R)
!!$  ag_a(1,:) = g_R
!!$  ag_a(2,:) = g_R**2
  aq_a = aq_ag(ag_a)

!----- aq_BoundaryTau_D ------
  write(6,*) 'Test of aq_BoundaryTau_D...'
  call aq_BoundaryTau_D(aq_a,value)
  ag_a = ag_aq(aq_a)
  write(6,*) ag_a(1,:)
  write(6,*) ag_a(2,:)
  if ( maxval(abs(ag_a(:,im)-value(:))) > eps ) then
     call MessageNotify('E','Test of aq_BoundaryTau_D', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of aq_BoundaryTau_D', &
       'Test of aq_BoundaryTau_D suceeded!')

!----- aq_BoundaryTau_N ------
  write(6,*) 'Test of aq_BoundaryTau_N...'

  ag_a(1,:) = sin(g_R)
  ag_a(2,:) = cos(g_R)
  aq_a = aq_ag(ag_a)

  call aq_BoundaryTau_N(aq_a,value)
  ag_a = ag_aq(aq_a)
  ag_dadx = ag_aq(aq_rDr_aq(aq_a))/spread(g_R,1,lm)

  write(6,*) ag_dadx(1,:)
  write(6,*) ag_dadx(2,:)

  if ( maxval(abs(ag_dadx(:,im)-value(:)))> eps )then
     call MessageNotify('E','Test of aq_BoundaryTau_N', &
          'B.C. adoption error too large.')
  endif
  call MessageNotify('M','Test of aq_BoundaryTau_N', &
       'Test of aq_BoundaryTau_N suceeded!')

end program aq_test_boundary_tau_2d
