#
# map3d4.rb
#   $Id: map3d4.rb,v 1.1 2000/11/18 19:03:39 keiko Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math


xmin = -50
xmax = 50
ymin = -50
ymax = 50
vxmin = 0.0
vxmax = 0.8
vymin = 0.0
vymax = 0.8
zmin = -50
zmax = 50
vzmin = 0.0
vzmax = 0.8
xvp3 = 2.5
yvp3 = -1.0
zvp3 = 1.5
xfc3 = (vxmax-vxmin)/2
yfc3 = (vymax-vymin)/2
zfc3 = (vzmax-vzmin)/2


def aplot(ijk)

  nmax = 40
  x = NArray.sfloat(nmax+1)
  y = NArray.sfloat(nmax+1)

  DCL::slpvpr(1)

  dt = 2.0*PI / nmax
  for n in 0..nmax
    x[n] = 40.0*sin(n*dt)
    y[n] = 40.0*cos(n*dt)
  end

 DCL:: sgplu(x, y)

  dt = 2.0*PI / 3
  for n in 0..3
    x[n] = 40.0*sin(n*dt)
    y[n] = 40.0*cos(n*dt)
  end

  DCL::sgplu(x, y)

  DCL::sgstxs(0.07)
  DCL::sgtxu(0.0, 0.0, 'DENNOU')
  cttl= format("%2.2d",ijk)
  DCL::sgtxu(0.0, -30.0, cttl)

end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sgiset('IFONT', 2)

DCL::sgfrm

#-- X-Y PLANE ----
DCL::sgswnd(xmin, xmax, ymin, ymax)
DCL::sgsvpt(vxmin, vxmax, vymin, vymax)
DCL::sgstrn(1)
DCL::sgstrf

DCL::scspln(1, 2, vzmax)
DCL::scseye(xvp3, yvp3, zvp3)
DCL::scsobj(xfc3, yfc3, zfc3)
DCL::scsprj

aplot(1)

#-- X-Z PLANE ----
DCL::sgswnd(xmin, xmax, zmin, zmax)
DCL::sgsvpt(vxmin, vxmax, vzmin, vzmax)
DCL::sgstrn(1)
DCL::sgstrf

DCL::scspln(1, 3, vymin)
DCL::scsprj

aplot(2)

#-- Y-Z PLANE ----
DCL::sgswnd(ymin, ymax, zmin, zmax)
DCL::sgsvpt(vymin, vymax, vzmin, vzmax)
DCL::sgstrn(1)
DCL::sgstrf

DCL::scspln(2, 3, vxmax)
DCL::scsprj

aplot(3)

DCL::sgcls
