#
# uspk02.rb
#
# $Id: uspk02.rb,v 1.1 2000/11/22 14:36:02 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 100
x = NArray.sfloat(n)
y = NArray.sfloat(n)

#---------------------------- DATA DEFINITION --------------------------
r = 0.2
a = 3.6
r0 = 0.0
for i in 0..n-1
  r = a*r*(1.0-r)
  r0 = r0 + r*4 - 2.58
  x2 = (i-49.0)**2
  rexp = 4.0*(i+1)/n
  x[i] = 10**rexp
  y[i] = 1.0e5*exp(-x2) + 10.0**r0
end
y[19] = 1.0e4
y[39] = 2.0e3
y[64] = 3.0e4
y[69] = 5.0e2

#----------------------------- GRAPH -----------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::grstrn(4)

DCL::usgrph(x, y)

DCL::grcls

#-----------------------------------------------------------------------

