require 'narray'
require 'numru/gphys'
require 'numru/derivative'

############################################################

=begin
=module NumRu::GPhys::Derivative in derivative.rb

==todo
* 1 Ԥ 80 ʸǼ 
* Recast document in English  

==Index
* ((<module NumRu::GPhys::Derivative>))
  * ((<cderiv>))
    * First derivative (using center difference method)

=module NumRu::GPhys::Derivative

Module functions of Derivative Operater for NArray.
ʬ黻⥸塼. Ĥμ˱äʬ֤ͤ.

---cderiv(data, dim_or_dimname, bc=NumRu::Derivative::LINEAR_EXT)

    First derivate (({data})) respect to  (({dim})) th or (({dimname})) 
    dimention. (({data})) κʬ (({axis})) κʬǳä 
      ( ʤ (na_{i+1} - na_{i-1}) / (x_{i+1} - x_{i-1}):  na  (({data})), 
       x  ((<dim>)) ܤμ, _{i}  ((<dim>)) ܤ i ܤźɽ ) 
    ֤.


    ARGUMENTS
    * data (NArray): a NArray which you want to derivative.
    * dim_or_dimname (Numeric or String): a Numeric or String representing 
      the dimension which derivate respect to. (dim<0)
      ȤǤ뤬, data.rank dim < 0 ȤʤäƤϤʤ.
    * bc (Numeric) : . NumRu::Derivative::LINEAR_EXT ü2˳ĥ,
      ((<NumRu::Derivative::b_expand_linear_ext>)) Ƥ. ߤĥ
     ݡȤƤʤ.


    RETURN VALUE
    * a GPhys

=end
############################################################

module NumRu
  class GPhys
    module Derivative

      module_function

      def cderiv(gp,dim,bc=NumRu::Derivative::LINEAR_EXT)
	# <<get dimention number>>
	if (dim.is_a?(Numeric) && dim < 0)
	  dim += gp.rank - 1
	elsif dim.is_a?(String)
	  dim = gp.axnames.index(dim) 
	end

	# <<derivate gp>>
	v_data = gp.data;       v_x = gp.coord(dim)            # get varray
	n_data = v_data.val;    n_x = v_x.val                  # get narray
	n_dgpdx = NumRu::Derivative::cderiv(n_data,n_x,dim,bc) # derivate n_data
        name = "d#{gp.name}_d#{v_x.name}"                      # ex. "dT_dx"
	v_dgpdx = VArray.new(n_dgpdx, gp.data, name)           # make varray 
	g_dgpdx = GPhys.new( gp.grid_copy, v_dgpdx )           # make gphys 

        # <<set attribute>>
	u_data = v_data.units;  u_x = v_x.units                # get units
	g_dgpdx.units = u_data/u_x                             # set units
	if v_data.get_att('long_name') && v_x.get_att('long_name')
	  long_name = "d_#{v_data.get_att('long_name')}_d_#{v_x.get_att('long_name')}"
	else
	  long_name = name
	end
	g_dgpdx.data.set_att("long_name",long_name)            # set long_name
	return g_dgpdx
      end

    end
  end  
end


######################################################
## < test >
if $0 == __FILE__

  include NumRu
  include NMath

  dim = "lon"
  nlon = 180
  nlat = 90
  print "###########\n"
  v_lon = VArray.new( NArray.sfloat(nlon).indgen(0,360.0/nlon),
		   {"long_name"=>"longitude", "units"=>"degrees_east"},
		     "lon" )
  lon = Axis.new.set_pos(v_lon)
  v_lat = VArray.new( NArray.sfloat(nlat).indgen(-90,180/nlat),
		   {"long_name"=>"latitude","units"=>"degrees"},
		     "lat" )
  lat = Axis.new.set_pos(v_lat)
  data = VArray.new( NArray.sfloat(nlon,nlat).indgen,
		    {"long_name"=>"temperature", "units"=>"K"},
		    "T" )
  p  gphys = GPhys.new( Grid.new(lon,lat), data )
  p  g_dgpdx = NumRu::GPhys::Derivative::cderiv(gphys,dim)
  g_dgpdx.data.get_att("long_name")
  g_dgpdx.data.att_names.each{|nm| p nm, g_dgpdx.data.get_att(nm).to_s}
  
  # calculate cos(v_lat)
  if g_dgpdx.coord("lon").units.to_s =~ /(.*)degree(.*)/
    deg = g_dgpdx.coord("lat").units
    lat_rad = deg.convert(g_dgpdx.coord("lat"), Units["rad"])
    cosx  = Misc::EMath::cos(lat_rad).val.newdim(0)
  else
    lat_rad = g_dgpdx.coord("lat")
    cosx  = Misc::EMath::cos(lat_rad).val.newdim(0)
  end
  p g_dgpdx__cosx = g_dgpdx*cosx
  g_dgpdx__cosx.data.att_names.each{|nm| p nm, g_dgpdx__cosx.data.get_att(nm).to_s}
  print "###########\n"
end
