require 'rbconfig'
require 'find'
require "ftools"
require 'getopts'

CONFIG = Config::MAKEFILE_CONFIG

a=getopts(nil, 'prefix:')
if a>=2
  raise StandardError, "too many option"
end

prefix = CONFIG["prefix"]
sitedir = CONFIG["sitedir"]+"/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/numru"
sitedir.gsub!(/\$\(prefix\)/, CONFIG["prefix"])
sitelibdir = sitedir+"/gphys"

if $OPT_prefix
  sitedir = CONFIG["sitedir"]+"/"+CONFIG["MAJOR"]+"."+CONFIG["MINOR"]+"/numru"
  sitedir.gsub!(/\$\(prefix\)/, $OPT_prefix)
  sitelibdir = sitedir+"/gphys"
end 

srcdir = File.dirname($0)

Dir[File.join(sitelibdir, "*.rb")].each{|file|
   libfile = srcdir + "/" + File.basename(file)
   if(!File.exist?(libfile))
      File.unlink(file)
   end
}

Dir[File.join(srcdir || ".", "*.rb")].each{|file|
  if(/install.rb/ =~ file || /test/ =~ file)
  elsif(/gphysrect.rb/ =~ file)
    file = File.basename(file)
    File::makedirs(sitedir)
    File::install(file, sitedir+"/"+file, 0644, true)
  else
    file = File.basename(file)
    File::makedirs(sitelibdir)
    File::install(file, sitelibdir+"/"+file, 0644, true)
  end
}
