%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkRendering_typemaps.i


%{
#include "vtkVolumeTextureMapper.h"
#include "vtkEncodedGradientEstimator.h"
#include "vtkEncodedGradientShader.h"
#include "vtkRenderWindow.h"
#include "vtkRenderer.h"
#include "vtkVolume.h"
%}

%import vtkVolumeMapper.h


%{
extern void vtkVolumeTextureMapper_freefunc(void *ptr)
{
    vtkVolumeTextureMapper *obj;
    obj = (vtkVolumeTextureMapper*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetDataOrigin()
}
%ignore GetDataOrigin(float data[3]);
%ignore GetDataOrigin(float _arg[3]);
%ignore GetDataOrigin(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetDataSpacing()
}
%ignore GetDataSpacing(float data[3]);
%ignore GetDataSpacing(float _arg[3]);
%ignore GetDataSpacing(float &_arg1,float &_arg2,float &_arg3);

%include vtkVolumeTextureMapper.h
