%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkImaging_typemaps.i


%{
#include "vtkImageGridSource.h"
%}

%import vtkImageSource.h


%{
extern void vtkImageGridSource_freefunc(void *ptr)
{
    vtkImageGridSource *obj;
    obj = (vtkImageGridSource*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetGridSpacing()
}
%ignore GetGridSpacing(int data[3]);
%ignore GetGridSpacing(int _arg[3]);
%ignore GetGridSpacing(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetGridOrigin()
}
%ignore GetGridOrigin(int data[3]);
%ignore GetGridOrigin(int _arg[3]);
%ignore GetGridOrigin(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetDataExtent()
}
%ignore GetDataExtent(int data[6]);
%ignore GetDataExtent(int _arg[6]);
%ignore GetDataExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetDataSpacing()
}
%ignore GetDataSpacing(double data[3]);
%ignore GetDataSpacing(double _arg[3]);
%ignore GetDataSpacing(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetDataOrigin()
}
%ignore GetDataOrigin(double data[3]);
%ignore GetDataOrigin(double _arg[3]);
%ignore GetDataOrigin(double &_arg1,double &_arg2,double &_arg3);

%include vtkImageGridSource.h
