%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkCommon_typemaps.i


%{
#include "vtkCallbackCommand.h"
%}

%import vtkCallbackCommand.h


%inline %{
class vtkRubyCallbackCommand : public vtkCommand
{
public:
  static vtkRubyCallbackCommand *New(){ return new vtkRubyCallbackCommand; };

  void SetCallback(VALUE proc)
    {this->Callback = proc;}
  void Execute(vtkObject *ptr, unsigned long eventtype, void *);

  VALUE Callback;
protected:
  vtkRubyCallbackCommand();
};
%}
%{
vtkRubyCallbackCommand::vtkRubyCallbackCommand()
{
  this->Callback = Qnil;
}
void vtkRubyCallbackCommand::Execute(vtkObject *caller, unsigned long event, void *callData)
{
  VALUE rcaller;
  VALUE revent;

  rcaller = SWIG_NewPointerObj((void*)caller, SWIGTYPE_p_vtkObject, 0);
  revent = ULONG2NUM(event);
  if (this->Callback)
    rb_funcall(this->Callback, rb_intern("call"), 2, rcaller, revent);
}
void vtkRubyCallbackCommand_markfunc(void *ptr)
{
    vtkRubyCallbackCommand *obj;
    obj = (vtkRubyCallbackCommand*)ptr;
    rb_gc_mark(obj->Callback);

}
void vtkRubyCallbackCommand_freefunc(void *ptr)
{
    vtkRubyCallbackCommand *obj;
    obj = (vtkRubyCallbackCommand*)ptr;
    obj->Delete();
}
%}

