%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkParallel_typemaps.i


%{
#include "vtkRTAnalyticSource.h"
%}

%import vtkImageSource.h


%{
extern void vtkRTAnalyticSource_freefunc(void *ptr)
{
    vtkRTAnalyticSource *obj;
    obj = (vtkRTAnalyticSource*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetWholeExtent()
}
%ignore GetWholeExtent(int data[6]);
%ignore GetWholeExtent(int _arg[6]);
%ignore GetWholeExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetCenter()
}
%ignore GetCenter(float data[3]);
%ignore GetCenter(float _arg[3]);
%ignore GetCenter(float &_arg1,float &_arg2,float &_arg3);

%include vtkRTAnalyticSource.h
