require "mkmf"


name = "Common"


dir_config("vtk","/usr/local/include/vtk","/usr/local/lib/vtk")
unless have_header("vtkConfigure.h")
  puts "header file for vtk is not found\n"
  puts "please retry with --with-vtk-inlucde=path\n"
  exit 1
end
unless have_library("vtk#{name}")
  puts "libvtk#{name}.[a|so] is not found\n"
  puts "please retry with --with-vtk-lib=path\n"
  exit 1
end


$objs = ["#{name}.o"]+File.open("#{name}_files"){|f|
  f.readlines.collect{|l| l.chop!+".o"}
}
$objs.delete("vtkOStrStreamWrapper.o")
$objs.delete("vtkOStreamWrapper.o")
$objs << "vtkConfigure.o"
$objs << "vtkToolkits.o"


$LIBS = $LIBS+" -lstdc++"
create_makefile("vtk/#{name}")

vtk_include = nil
$CPPFLAGS.split.each{|path|
  if path=~/vtk/
    vtk_include = path
    break
  end
}

require "ftools"
File.move("Makefile","Makefile.org")
File.open("Makefile","w"){|fw|
  File.foreach("Makefile.org"){|line|
    if line=~/^OBJS = (.*)$/
      srcs = $1.split.collect{|obj| obj.sub!(/\.o/,".cxx") }
      fw.print "SRCS = #{srcs.join(" ")}\n"
      fw.print line
    elsif line=~/^\.SUFFIXES: (.*)/
      fw.print ".SUFFIXES: .i #{$1}\n\n"
      fw.print ".i.cxx:\n"
      fw.print "	swig -c++ -ruby -c -w120,201,315,362,503,801 -ignoremissing -importall -feature $* -I.. -I../headers #{vtk_include} -o $@ $<\n"
    elsif line=~/^all:(\s*)(.*)$/
      fw.print "all:#{$1}srcs #{$2}\n"
      fw.print "srcs: $(SRCS)\n"
    else
      fw.print line
    end
  }
}
