require "narray"
require "numru/multibitnums"
include NumRu

testdata = ' '*10
for i in 0..testdata.length-1
  testdata[i] = 0x11    # set bit pattern of 000100010001...
end

print "test data = "
p testdata

for nbit in 2..10
  mb = MultiBitNums.new(testdata, nbit)
  print "\nInterpreted as #{nbit}-bit big-endian unsigned integers:\n"
  p NArray.to_na( mb.to_int32str, 'int' )
end
