/*
 * math2_fftlib.fp
 *
 * $Id: math2_fftlib.fp,v 1.3 2000/11/25 12:40:11 keiko Exp $
 */

/*****************************************************
 * math2/fftlib/cfftb.f
 ****************************************************/
/* 
 *      SUBROUTINE CFFTB (N,C,WSAVE)
 *      DIMENSION       C(*)       ,WSAVE(*)
 */
      SUBROUTINE CFFTB(
          INTEGER N
          REAL (2*N) io C
          REAL (4*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/cfftb1.f
 ****************************************************/
/* 
 *      SUBROUTINE CFFTB1 (N,C,CH,WA,IFAC)
 *      DIMENSION       CH(*)      ,C(*)       ,WA(*)      ,IFAC(*)
 */
/*
      SUBROUTINE CFFTB1(
          INTEGER N
          REAL (*) io C
          REAL (*) t CH
          REAL (*) t WA
          INTEGER (*) t IFAC
      )
*/

/*****************************************************
 * math2/fftlib/cfftf.f
 ****************************************************/
/* 
 *      SUBROUTINE CFFTF (N,C,WSAVE)
 *      DIMENSION       C(*)       ,WSAVE(*)
 */
      SUBROUTINE CFFTF(
          INTEGER N
          REAL (2*N) io C
          REAL (4*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/cfftf1.f
 ****************************************************/
/* 
 *      SUBROUTINE CFFTF1 (N,C,CH,WA,IFAC)
 *      DIMENSION       CH(*)      ,C(*)       ,WA(*)      ,IFAC(*)
 */
/*
      SUBROUTINE CFFTF1(
          INTEGER N
          REAL (*) io C
          REAL (*) t CH
          REAL (*) t WA
          INTEGER (*) t IFAC
      )
*/

/*****************************************************
 * math2/fftlib/cffti.f
 ****************************************************/
/* 
 *      SUBROUTINE CFFTI (N,WSAVE)
 *      DIMENSION       WSAVE(*)
 */
      SUBROUTINE CFFTI(
          INTEGER N
          REAL (4*N+15) o WSAVE
      )

/*****************************************************
 * math2/fftlib/cffti1.f
 ****************************************************/
/* 
 *      SUBROUTINE CFFTI1 (N,WA,IFAC)
 *      DIMENSION       WA(*)      ,IFAC(*)    ,NTRYH(4)
 */
/*
      SUBROUTINE CFFTI1(
          INTEGER N
          REAL (*) o WA
          INTEGER (*) o IFAC
      )
*/

/*****************************************************
 * math2/fftlib/cosqb.f
 ****************************************************/
/* 
 *      SUBROUTINE COSQB (N,X,WSAVE)
 *      DIMENSION       X(*)       ,WSAVE(*)
 */
      SUBROUTINE COSQB(
          INTEGER N
          REAL (N) io X
          REAL (3*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/cosqb1.f
 ****************************************************/
/* 
 *      SUBROUTINE COSQB1 (N,X,W,XH)
 *      DIMENSION       X(*)       ,W(*)       ,XH(*)
 */
/*
      SUBROUTINE COSQB1(
          INTEGER N
          REAL io X
          REAL (*) t W
          REAL (*) t XH
      )
*/

/*****************************************************
 * math2/fftlib/cosqf.f
 ****************************************************/
/* 
 *      SUBROUTINE COSQF (N,X,WSAVE)
 *      DIMENSION       X(*)       ,WSAVE(*)
 */
      SUBROUTINE COSQF(
          INTEGER N
          REAL (N) io X
          REAL (3*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/cosqf1.f
 ****************************************************/
/* 
 *      SUBROUTINE COSQF1 (N,X,W,XH)
 *      DIMENSION       X(*)       ,W(*)       ,XH(*)
 */
/*
      SUBROUTINE COSQF1(
          INTEGER N
          REAL io X
          REAL (*) t W
          REAL (*) t XH
      )
*/

/*****************************************************
 * math2/fftlib/cosqi.f
 ****************************************************/
/* 
 *      SUBROUTINE COSQI (N,WSAVE)
 *      DIMENSION       WSAVE(*)
 */
      SUBROUTINE COSQI(
          INTEGER N
          REAL (3*N+15) o WSAVE
      )

/*****************************************************
 * math2/fftlib/cost.f
 ****************************************************/
/* 
 *      SUBROUTINE COST (N,X,WSAVE)
 *      DIMENSION       X(*)       ,WSAVE(*)
 */
      SUBROUTINE COST(
          INTEGER N
          REAL (N) io X
          REAL (3*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/costi.f
 ****************************************************/
/* 
 *      SUBROUTINE COSTI (N,WSAVE)
 *      DIMENSION       WSAVE(*)
 */
      SUBROUTINE COSTI(
          INTEGER N
          REAL (3*N+15) o WSAVE
      )

/*****************************************************
 * math2/fftlib/ezfft1.f
 ****************************************************/
/* 
 *      SUBROUTINE EZFFT1 (N,WA,IFAC)
 *      DIMENSION       WA(*)      ,IFAC(*)    ,NTRYH(4)
 */
/*
      SUBROUTINE EZFFT1(
          INTEGER N
          REAL (*) o WA
          INTEGER (*) o IFAC
      )
*/

/*****************************************************
 * math2/fftlib/ezfftb.f
 ****************************************************/
/* 
 *      SUBROUTINE EZFFTB (N,R,AZERO,A,B,WSAVE)
 *      DIMENSION       R(*)       ,A(*)       ,B(*)       ,WSAVE(*)
 */
      SUBROUTINE EZFFTB(
          INTEGER N
          REAL (N) o R
          REAL AZERO
/*          REAL A */
          REAL (N/2) A
          REAL (N/2) B
          REAL (3*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/ezfftf.f
 ****************************************************/
/* 
 *      SUBROUTINE EZFFTF (N,R,AZERO,A,B,WSAVE)
 *      DIMENSION       R(*)       ,A(*)       ,B(*)       ,WSAVE(*)
 */
      SUBROUTINE EZFFTF(
          INTEGER N
          REAL (N) R
          REAL o AZERO
/*          REAL o A */
          REAL (N/2) o A
          REAL (N/2) o B
          REAL (3*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/ezffti.f
 ****************************************************/
/* 
 *      SUBROUTINE EZFFTI (N,WSAVE)
 *      DIMENSION       WSAVE(*)
 */
      SUBROUTINE EZFFTI(
          INTEGER N
          REAL (3*N+15) o WSAVE
      )

/*****************************************************
 * math2/fftlib/passb.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSB (NAC,IDO,IP,L1,IDL1,CC,C1,C2,CH,CH2,WA)
 *      DIMENSION       CH(IDO,L1,IP)          ,CC(IDO,IP,L1)          ,
 */
/*
      SUBROUTINE PASSB(
          INTEGER o NAC
          INTEGER IDO
          INTEGER IP
          INTEGER L1
          INTEGER IDL1
          REAL (IDO,IP,L1) CC
          REAL io C1
          REAL io C2
          REAL (IDO,L1,IP) io CH
          REAL io CH2
          REAL WA
      )
*/

/*****************************************************
 * math2/fftlib/passb2.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSB2 (IDO,L1,CC,CH,WA1)
 *      DIMENSION       CC(IDO,2,L1)           ,CH(IDO,L1,2)           ,
 */
/*
      SUBROUTINE PASSB2(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,2,L1) CC
          REAL (IDO,L1,2) o CH
          REAL WA1
      )
*/

/*****************************************************
 * math2/fftlib/passb3.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSB3 (IDO,L1,CC,CH,WA1,WA2)
 *      DIMENSION       CC(IDO,3,L1)           ,CH(IDO,L1,3)           ,
 */
/*
      SUBROUTINE PASSB3(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,3,L1) CC
          REAL (IDO,L1,3) o CH
          REAL WA1
          REAL WA2
      )
*/

/*****************************************************
 * math2/fftlib/passb4.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSB4 (IDO,L1,CC,CH,WA1,WA2,WA3)
 *      DIMENSION       CC(IDO,4,L1)           ,CH(IDO,L1,4)           ,
 */
/*
      SUBROUTINE PASSB4(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,4,L1) CC
          REAL (IDO,L1,4) o CH
          REAL WA1
          REAL WA2
          REAL WA3
      )
*/

/*****************************************************
 * math2/fftlib/passb5.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSB5 (IDO,L1,CC,CH,WA1,WA2,WA3,WA4)
 *      DIMENSION       CC(IDO,5,L1)           ,CH(IDO,L1,5)           ,
 */
/*
      SUBROUTINE PASSB5(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,5,L1) CC
          REAL (IDO,L1,5) o CH
          REAL WA1
          REAL WA2
          REAL WA3
          REAL WA4
      )
*/

/*****************************************************
 * math2/fftlib/passf.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSF (NAC,IDO,IP,L1,IDL1,CC,C1,C2,CH,CH2,WA)
 *      DIMENSION       CH(IDO,L1,IP)          ,CC(IDO,IP,L1)          ,
 */
/*
      SUBROUTINE PASSF(
          INTEGER o NAC
          INTEGER IDO
          INTEGER IP
          INTEGER L1
          INTEGER IDL1
          REAL (IDO,IP,L1) CC
          REAL io C1
          REAL io C2
          REAL (IDO,L1,IP) io CH
          REAL io CH2
          REAL WA
      )
*/

/*****************************************************
 * math2/fftlib/passf2.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSF2 (IDO,L1,CC,CH,WA1)
 *      DIMENSION       CC(IDO,2,L1)           ,CH(IDO,L1,2)           ,
 */
/*
      SUBROUTINE PASSF2(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,2,L1) CC
          REAL (IDO,L1,2) o CH
          REAL WA1
      )
*/

/*****************************************************
 * math2/fftlib/radb2.f
 ****************************************************/
/* 
 *      SUBROUTINE RADB2 (IDO,L1,CC,CH,WA1)
 *      DIMENSION       CC(IDO,2,L1)           ,CH(IDO,L1,2)           ,
 */
/*
      SUBROUTINE RADB2(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,2,L1) CC
          REAL (IDO,L1,2) o CH
          REAL WA1
      )
*/

/*****************************************************
 * math2/fftlib/passf3.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSF3 (IDO,L1,CC,CH,WA1,WA2)
 *      DIMENSION       CC(IDO,3,L1)           ,CH(IDO,L1,3)           ,
 */
/*
      SUBROUTINE PASSF3(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,3,L1) CC
          REAL (IDO,L1,3) o CH
          REAL WA1
          REAL WA2
      )
*/

/*****************************************************
 * math2/fftlib/passf4.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSF4 (IDO,L1,CC,CH,WA1,WA2,WA3)
 *      DIMENSION       CC(IDO,4,L1)           ,CH(IDO,L1,4)           ,
 */
/*
      SUBROUTINE PASSF4(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,4,L1) CC
          REAL (IDO,L1,4) o CH
          REAL WA1
          REAL WA2
          REAL WA3
      )
*/

/*****************************************************
 * math2/fftlib/passf5.f
 ****************************************************/
/* 
 *      SUBROUTINE PASSF5 (IDO,L1,CC,CH,WA1,WA2,WA3,WA4)
 *      DIMENSION       CC(IDO,5,L1)           ,CH(IDO,L1,5)           ,
 */
/*
      SUBROUTINE PASSF5(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,5,L1) CC
          REAL (IDO,L1,5) o CH
          REAL WA1
          REAL WA2
          REAL WA3
          REAL WA4
      )
*/

/*****************************************************
 * math2/fftlib/radb3.f
 ****************************************************/
/* 
 *      SUBROUTINE RADB3 (IDO,L1,CC,CH,WA1,WA2)
 *      DIMENSION       CC(IDO,3,L1)           ,CH(IDO,L1,3)           ,
 */
/*
      SUBROUTINE RADB3(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,3,L1) CC
          REAL (IDO,L1,3) o CH
          REAL WA1
          REAL WA2
      )
*/

/*****************************************************
 * math2/fftlib/radb4.f
 ****************************************************/
/* 
 *      SUBROUTINE RADB4 (IDO,L1,CC,CH,WA1,WA2,WA3)
 *      DIMENSION       CC(IDO,4,L1)           ,CH(IDO,L1,4)           ,
 */
/*
      SUBROUTINE RADB4(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,4,L1) CC
          REAL (IDO,L1,4) o CH
          REAL WA1
          REAL WA2
          REAL WA3
      )
*/

/*****************************************************
 * math2/fftlib/radb5.f
 ****************************************************/
/* 
 *      SUBROUTINE RADB5 (IDO,L1,CC,CH,WA1,WA2,WA3,WA4)
 *      DIMENSION       CC(IDO,5,L1)           ,CH(IDO,L1,5)           ,
 */
/*
      SUBROUTINE RADB5(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,5,L1) CC
          REAL (IDO,L1,5) o CH
          REAL WA1
          REAL WA2
          REAL WA3
          REAL WA4
      )
*/

/*****************************************************
 * math2/fftlib/radbg.f
 ****************************************************/
/* 
 *      SUBROUTINE RADBG (IDO,IP,L1,IDL1,CC,C1,C2,CH,CH2,WA)
 *      DIMENSION       CH(IDO,L1,IP)          ,CC(IDO,IP,L1)          ,
 */
/*
      SUBROUTINE RADBG(
          INTEGER IDO
          INTEGER IP
          INTEGER L1
          INTEGER IDL1
          REAL (IDO,IP,L1) CC
          REAL io C1
          REAL io C2
          REAL (IDO,L1,IP) io CH
          REAL io CH2
          REAL WA
      )
*/

/*****************************************************
 * math2/fftlib/radf2.f
 ****************************************************/
/* 
 *      SUBROUTINE RADF2 (IDO,L1,CC,CH,WA1)
 *      DIMENSION       CH(IDO,2,L1)           ,CC(IDO,L1,2)           ,
 */
/*
      SUBROUTINE RADF2(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,L1,2) CC
          REAL (IDO,2,L1) o CH
          REAL WA1
      )
*/

/*****************************************************
 * math2/fftlib/radf3.f
 ****************************************************/
/* 
 *      SUBROUTINE RADF3 (IDO,L1,CC,CH,WA1,WA2)
 *      DIMENSION       CH(IDO,3,L1)           ,CC(IDO,L1,3)           ,
 */
/*
      SUBROUTINE RADF3(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,L1,3) CC
          REAL (IDO,3,L1) o CH
          REAL WA1
          REAL WA2
      )
*/

/*****************************************************
 * math2/fftlib/radf4.f
 ****************************************************/
/* 
 *      SUBROUTINE RADF4 (IDO,L1,CC,CH,WA1,WA2,WA3)
 *      DIMENSION       CC(IDO,L1,4)           ,CH(IDO,4,L1)           ,
 */
/*
      SUBROUTINE RADF4(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,L1,4) CC
          REAL (IDO,4,L1) o CH
          REAL WA1
          REAL WA2
          REAL WA3
      )
*/

/*****************************************************
 * math2/fftlib/radf5.f
 ****************************************************/
/* 
 *      SUBROUTINE RADF5 (IDO,L1,CC,CH,WA1,WA2,WA3,WA4)
 *      DIMENSION       CC(IDO,L1,5)           ,CH(IDO,5,L1)           ,
 */
/*
      SUBROUTINE RADF5(
          INTEGER IDO
          INTEGER L1
          REAL (IDO,L1,5) CC
          REAL (IDO,5,L1) o CH
          REAL WA1
          REAL WA2
          REAL WA3
          REAL WA4
      )
*/

/*****************************************************
 * math2/fftlib/radfg.f
 ****************************************************/
/* 
 *      SUBROUTINE RADFG (IDO,IP,L1,IDL1,CC,C1,C2,CH,CH2,WA)
 *      DIMENSION       CH(IDO,L1,IP)          ,CC(IDO,IP,L1)          ,
 */
/*
      SUBROUTINE RADFG(
          INTEGER IDO
          INTEGER IP
          INTEGER L1
          INTEGER IDL1
          REAL (IDO,IP,L1) CC
          REAL io C1
          REAL io C2
          REAL (IDO,L1,IP) io CH
          REAL io CH2
          REAL WA
      )
*/

/*****************************************************
 * math2/fftlib/rfftb.f
 ****************************************************/
/* 
 *      SUBROUTINE RFFTB (N,R,WSAVE)
 *      DIMENSION       R(*)       ,WSAVE(*)
 */
      SUBROUTINE RFFTB(
          INTEGER N
          REAL (N) io R
          REAL (2*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/rfftb1.f
 ****************************************************/
/* 
 *      SUBROUTINE RFFTB1 (N,C,CH,WA,IFAC)
 *      DIMENSION       CH(*)      ,C(*)       ,WA(*)      ,IFAC(*)
 */
/*
      SUBROUTINE RFFTB1(
          INTEGER N
          REAL (*) io C
          REAL (*) t CH
          REAL (*) t WA
          INTEGER (*) t IFAC
      )
*/

/*****************************************************
 * math2/fftlib/rfftf.f
 ****************************************************/
/* 
 *      SUBROUTINE RFFTF (N,R,WSAVE)
 *      DIMENSION       R(*)       ,WSAVE(*)
 */
      SUBROUTINE RFFTF(
          INTEGER N
          REAL (N) io R
          REAL (2*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/rfftf1.f
 ****************************************************/
/* 
 *      SUBROUTINE RFFTF1 (N,C,CH,WA,IFAC)
 *      DIMENSION       CH(*)      ,C(*)       ,WA(*)      ,IFAC(*)
 */
/*
      SUBROUTINE RFFTF1(
          INTEGER N
          REAL (*) io C
          REAL (*) t CH
          REAL (*) t WA
          INTEGER (*) t IFAC
      )
*/

/*****************************************************
 * math2/fftlib/rffti.f
 ****************************************************/
/* 
 *      SUBROUTINE RFFTI (N,WSAVE)
 *      DIMENSION       WSAVE(*)
 */
      SUBROUTINE RFFTI(
          INTEGER N
          REAL (2*N+15) o WSAVE
      )

/*****************************************************
 * math2/fftlib/rffti1.f
 ****************************************************/
/* 
 *      SUBROUTINE RFFTI1 (N,WA,IFAC)
 *      DIMENSION       WA(*)      ,IFAC(*)    ,NTRYH(4)
 */
/*
      SUBROUTINE RFFTI1(
          INTEGER N
          REAL (*) o WA
          INTEGER (*) o IFAC
      )
*/

/*****************************************************
 * math2/fftlib/sinqb.f
 ****************************************************/
/* 
 *      SUBROUTINE SINQB (N,X,WSAVE)
 *      DIMENSION       X(*)       ,WSAVE(*)
 */
      SUBROUTINE SINQB(
          INTEGER N
          REAL (N) io X
          REAL (3*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/sinqf.f
 ****************************************************/
/* 
 *      SUBROUTINE SINQF (N,X,WSAVE)
 *      DIMENSION       X(*)       ,WSAVE(*)
 */
      SUBROUTINE SINQF(
          INTEGER N
          REAL (N) io X
          REAL (3*N+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/sinqi.f
 ****************************************************/
/* 
 *      SUBROUTINE SINQI (N,WSAVE)
 *      DIMENSION       WSAVE(*)
 */
      SUBROUTINE SINQI(
          INTEGER N
          REAL (3*N+15) o WSAVE
      )

/*****************************************************
 * math2/fftlib/sint.f
 ****************************************************/
/* 
 *      SUBROUTINE SINT (N,X,WSAVE)
 *      DIMENSION       X(*)       ,WSAVE(*)
 */
      SUBROUTINE SINT(
          INTEGER N
          REAL (N) io X
          REAL (2*N+N/2+15) WSAVE
      )

/*****************************************************
 * math2/fftlib/sint1.f
 ****************************************************/
/* 
 *      SUBROUTINE SINT1(N,WAR,WAS,XH,X,IFAC)
 *      DIMENSION WAR(*),WAS(*),X(*),XH(*),IFAC(*)
 */
/*
      SUBROUTINE SINT1(
          INTEGER N
          REAL (*) io WAR
          REAL (*) t WAS
          REAL (*) t XH
          REAL t X
          INTEGER (*) t IFAC
      )
*/

/*****************************************************
 * math2/fftlib/sinti.f
 ****************************************************/
/* 
 *      SUBROUTINE SINTI (N,WSAVE)
 *      DIMENSION       WSAVE(*)
 */
      SUBROUTINE SINTI(
          INTEGER N
          REAL (2*N+N/2+15) o WSAVE
      )

