#!/usr/bin/env ruby
require("gsl")
require("../gsl_test2.rb")
include GSL::Test
include Math

N = 397
NR = 10
xr = Vector.new(0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0)
GSL::IEEE.env_setup()

h = Histogram.calloc(N)
h1 = Histogram.calloc(N)
g = Histogram.calloc(N)

GSL::Test::test(h.range == 0 ? 1 : 0, "gsl_histogram_alloc returns valid range pointer");
GSL::Test::test(h.bin == 0 ? 1 : 0, "gsl_histogram_alloc returns valid bin pointer");
GSL::Test::test(h.n != N ? 1 : 0, "gsl_histogram_alloc returns valid size");

hr = Histogram.calloc_range(NR, xr)
test(hr.range == 0 ? 1 : 0, "gsl_histogram_calloc_range returns valid range pointer");
test(hr.bin == 0 ? 1 : 0, "gsl_histogram_calloc_range returns valid bin pointer"
);
test(hr.n != NR ? 1 : 0, "gsl_histogram_calloc_range returns valid size");

status = 0
for i in 0..NR
  if hr.range[i] != xr[i]
    status += 1
  end
end
test(status, "gsl_histogram_calloc_range creates range")

hr.set_ranges(xr, NR+1)
status = 0
for i in 0..NR
  if hr.range[i] != xr[i]
    status += 1
  end
end
test(status, "gsl_histogram_calloc_range creates range")

for i in 0...N
  h.accumulate(i.to_f, i.to_f)
end
status = 0
for i in 0...N
  if h.bin[i].to_i != i
    status += 1
  end
end
test(status, "gsl_histogram_accumulate writes into array")

status = 0
for i in 0...N
  if h.get(i) != i
    status += 1
  end
end
test(status, "gsl_histogram_get reads from array")
