#!/usr/bin/env ruby
require("gsl")
include MultiFit

N = 100

y0 = 1
A = 1.5
fc = 0.7
phi = 0.2

r = Rng.new()
x = Vector.linspace(0, 12, N)
y =  y0 + A*Sf::sin(fc*x+phi) + 0.1*r.gaussian(1, N)

coef, err, chi2, dof = MultiFit::FdfSolver.fit(x, y, "sin")
y0 = coef[0]
amp = coef[1]
fc = coef[2]
phi = coef[3]
p coef
p err
graph(x, y, y0+amp*Sf::sin(fc*x+phi))
