#!/usr/bin/env ruby
require("gsl")
require("../gsl_test.rb")
include GSL::Test

dbleps = 1e-6
n = 1
alpha = -0.3
x = Vector.new(0.029)
y = Vector.new(-0.992)
expected = Vector.new(-1.0007)
y2 = Blas.daxpy(alpha, x, y)
for i in 0...n do
  GSL::Test::test_rel(y2[i], expected[i], dbleps, "daxpy")
end

alpha = GSL::Complex.new(0, 1)
x = Vector::Complex.new([[0.776, -0.671]])
y = Vector::Complex.new([[0.39, 0.404]])
expected = Vector::Complex.new([[1.061, 1.18]])
y2 = Blas.zaxpy(alpha, x, y)
for i in 0...n do
  GSL::Test::test_rel(y2[i].re, expected[i].re, dbleps, "zaxpy real")
  GSL::Test::test_rel(y2[i].im, expected[i].im, dbleps, "zaxpy imag")
end
