
# m4 macros from the Unidata netcdf 2.3.2 pl4 distribution. Modified for use
# with GNU Autoconf 2.1. I renamed these from UC_* to DODS_* so that there
# will not be confusion when porting future versions of netcdf into the DODS
# source distribution. Unidata, Inc. wrote the text of these macros and holds
# a copyright on them.
#
# jhrg 3/27/95
#
# Hacked many times. No much reduced in size. Virtually non of the Unidata
# macros remain in this file. jhrg 5/09/05
#
# $Id: acinclude.m4 11963 2005-08-17 19:39:57Z jimg $

builtin(include, ud_aclocal.m4)

# Added by Ethan, 1999/06/21
# Look for perl.
# 
# I modified the regexp below to remove any text that follows the version
# number. This extra text was hosing the test. 7/15/99 jhrg

AC_DEFUN([DODS_PROG_PERL], [dnl
    AC_CHECK_PROG(PERL, perl, `which perl`)
    case "$PERL" in
	*perl*)
	    perl_ver=`$PERL -v 2>&1 | awk '/This is perl/ {print}'`
	    perl_ver=`echo $perl_ver | sed 's/This is perl,[[^0-9]]*\([[0-9._]]*\).*/\1/'`
            perl_ver_main=`echo $perl_ver | sed 's/\([[0-9]]*\).*/\1/'`
	    if test -n "$perl_ver" && test $perl_ver_main -ge 5
	    then
		AC_MSG_RESULT(Found perl version ${perl_ver}.)
	    else
		AC_MSG_ERROR(perl version: found ${perl_ver} should be at least 5.000.)
	    fi
	    ;;
	*)
	    AC_MSG_WARN(perl is required.)
	    ;;
    esac

    AC_SUBST(PERL)])

# Added by Ethan, 1999/06/21
# Look for GNU tar.
# 
# I modified the regexp below but it still does not work exactly correctly; 
# the variable tar_ver should have only the version number in it. However,
# my version (1.12) spits out a multi-line thing. The regexp below gets the
# version number from the first line but does not remove the subsequent lines
# of garbage. 7/15/99 jhrg
# Added awk line to handle multiline output. 1999/07/22 erd

AC_DEFUN([DODS_PROG_GTAR], [dnl
    AC_CHECK_PROGS(TAR,gtar tar,tar)
    case "$TAR" in
	*tar)
	    tar_ver=`$TAR --version 2>&1 | awk '/G[[Nn]][[Uu]] tar/ {print}'`
	    tar_ver=`echo $tar_ver | sed 's/.*GNU tar[[^0-9.]]*\([[0-9._]]*\)/\1/'`
	    if test -n "$tar_ver"
	    then
		AC_MSG_RESULT(Found Gnu tar version ${tar_ver}.)
	    else
		AC_MSG_WARN(GNU tar is required for some Makefile targets.)
	    fi
	    ;;
	*)
	    AC_MSG_WARN(GNU tar is required for some Makefile targets.)
	    ;;
    esac

    AC_SUBST(TAR)])

AC_DEFUN([DODS_DEBUG_OPTION], [dnl
    AC_ARG_ENABLE(debug, 
		  [  --enable-debug=ARG      Program instrumentation (1,2)],
		  DEBUG=$enableval, DEBUG=no)

    case "$DEBUG" in
    no) 
      ;;
    1)
      AC_MSG_RESULT(Setting debugging to level 1)
      AC_DEFINE(DODS_DEBUG)
      ;;
    2) 
      AC_MSG_RESULT(Setting debugging to level 2)
      AC_DEFINE(DODS_DEBUG, , [Set instrumentation to level 1 (see debug.h)])
      AC_DEFINE(DODS_DEBUG2, , [Set instrumentation to level 2])
      ;;
    *)
      AC_MSG_ERROR(Bad debug value)
      ;;
    esac])

AC_DEFUN([DODS_OS], [dnl
    AC_MSG_CHECKING(type of operating system)
    # I have removed the following test because some systems (e.g., SGI)
    # define OS in a way that breaks this code but that is close enough
    # to also be hard to detect. jhrg 3/23/97
    #  if test -z "$OS"; then
    #  fi 
    OS=`uname -s | tr '[[A-Z]]' '[[a-z]]' | sed 's;/;;g'`
    if test -z "$OS"; then
        AC_MSG_WARN(OS unknown!)
    fi
    case $OS in
        aix)
            ;;
        hp-ux)
            OS=hpux`uname -r | sed 's/[[A-Z.0]]*\([[0-9]]*\).*/\1/'`
            ;;
        irix)
            OS=${OS}`uname -r | sed 's/\..*//'`
            ;;
        # I added the following case because the `tr' command above *seems* 
	# to fail on Irix 5. I can get it to run just fine from the shell, 
	# but not in the configure script built using this macro. jhrg 8/27/97
        IRIX)
            OS=irix`uname -r | sed 's/\..*//'`
	    ;;
        osf*)
            ;;
        sn*)
            OS=unicos
            ;;
        sunos)
            OS_MAJOR=`uname -r | sed 's/\..*//'`
            OS=$OS$OS_MAJOR
            ;;
        ultrix)
            case `uname -m` in
            VAX)
                OS=vax-ultrix
                ;;
            esac
            ;;
        *)
            # On at least one UNICOS system, 'uname -s' returned the
            # hostname (sigh).
            if uname -a | grep CRAY >/dev/null; then
                OS=unicos
            fi
            ;;
    esac

    # Adjust OS for CRAY MPP environment.
    #
    case "$OS" in
    unicos)

        case "$CC$TARGET$CFLAGS" in
        *cray-t3*)
            OS=unicos-mpp
            ;;
        esac
        ;;
    esac

    AC_SUBST(OS)

    AC_MSG_RESULT($OS)])


AC_DEFUN([DODS_MACHINE], [dnl
    AC_MSG_CHECKING(type of machine)

    if test -z "$MACHINE"; then
    MACHINE=`uname -m | tr '[[A-Z]]' '[[a-z]]'`
    case $OS in
        aix*)
            MACHINE=rs6000
            ;;
        hp*)
            MACHINE=hp`echo $MACHINE | sed 's%/.*%%'`
            ;;
        sunos*)
            case $MACHINE in
                sun4*)
                    MACHINE=sun4
                    ;;
            esac
            ;;
        irix*)
            case $MACHINE in
                ip2?)
                    MACHINE=sgi
                    ;;
            esac
            ;;
	ultrix*)
	    case $MACHINE in
		vax*)
		     case "$CC" in
        		/bin/cc*|cc*)
echo "changing C compiler to \`vcc' because \`cc' floating-point is broken"
            		CC=vcc
            		;;
		     esac
		     ;;
	    esac
	    ;;

    esac
    fi

    AC_SUBST(MACHINE)
    AC_MSG_RESULT($MACHINE)])

AC_DEFUN([DODS_CHECK_SIZES], [dnl
    # Ignore the errors about AC_TRY_RUN missing an argument. jhrg 5/2/95

    AC_REQUIRE([AC_PROG_CC])

    AC_CHECK_SIZEOF(int)
    AC_CHECK_SIZEOF(long)
    AC_CHECK_SIZEOF(char)
    AC_CHECK_SIZEOF(double)
    AC_CHECK_SIZEOF(float)

    # Now generate symbols that define the dods_int32, ..., types
    # based on this machine's notion of an int, etc. See dods-datatypes.h.in.
    # I've separated the typedefs from the config_dap.h header because other
    # projects which use the DAP were getting conflicts with their includes,
    # or the includes of still other libraries, and config_dap.h. The 
    # config_dap.h header is now included only by .cc and .c files and headers
    # that need the typedefs use dods-datatypes.h. The code below makes 
    # dods-datatypes.h stand on its own. 8/2/2000 jhrg

    if test $ac_cv_sizeof_long -eq 4 
    then
	DODS_INT32=long
	DODS_UINT32="unsigned long"
	XDR_INT32=xdr_long
	XDR_UINT32=xdr_u_long
    elif test $ac_cv_sizeof_int -eq 4
    then
	DODS_INT32=int
	DODS_UINT32="unsigned int"
	XDR_INT32=xdr_int
	XDR_UINT32=xdr_u_int
    else
	AC_MSG_ERROR(How do I get a 32 bit integer on this machine?)
    fi
    # I'm using the three arg form of AC_DEFINE_UNQUOTED because autoheader
    # needs the third argument (although I don't quite get the specifics... 
    # 2/15/2001 jhrg
    AC_DEFINE_UNQUOTED(DINT32, $DODS_INT32, [int32])
    AC_DEFINE_UNQUOTED(DUINT32, $DODS_UINT32, [uint32])
    AC_DEFINE_UNQUOTED(XDR_INT32, $XDR_INT32, [xdr int32])
    AC_DEFINE_UNQUOTED(XDR_UINT32, $XDR_UINT32, [xdr uint32])

    # Assume nobody's hosed the 16-bit types...
    DODS_INT16=short
    DODS_UINT16="unsigned short"
    XDR_INT16=xdr_short
    XDR_UINT16=xdr_u_short
    AC_DEFINE_UNQUOTED(DINT16, $DODS_INT16, [dint16])
    AC_DEFINE_UNQUOTED(DUINT16, $DODS_UINT16, [uint16])
    AC_DEFINE_UNQUOTED(XDR_INT16, $XDR_INT16, [xdr int16])
    AC_DEFINE_UNQUOTED(XDR_UINT16, $XDR_UINT16, [xdr uint16])

    if test $ac_cv_sizeof_char -eq 1
    then
	DODS_BYTE="unsigned char"
    else
	AC_MSG_ERROR(How do I get an 8 bit unsigned integer on this machine?)
    fi
    AC_DEFINE_UNQUOTED(DBYTE, $DODS_BYTE, [dbyte])

    if test $ac_cv_sizeof_double -eq 8
    then
	DODS_FLOAT64=double
	DODS_FLOAT32=float
	XDR_FLOAT64=xdr_double
	XDR_FLOAT32=xdr_float
    else
	AC_MSG_ERROR(How do I get floating point types on this machine?)
    fi
    AC_DEFINE_UNQUOTED(DFLOAT64, $DODS_FLOAT64, [dfloat64])
    AC_DEFINE_UNQUOTED(DFLOAT32, $DODS_FLOAT32, [dfloat32])
    AC_DEFINE_UNQUOTED(XDR_FLOAT64, $XDR_FLOAT64, [xdr float64])
    AC_DEFINE_UNQUOTED(XDR_FLOAT32, $XDR_FLOAT32, [xdr float32])])


