
Name: libnc-dap
Summary: The C++ NetCDF-DAP2 library from OPeNDAP
Version: 3.5.2
Release: 3

Source0: http://www.opendap.org/pub/3.5/source/%{name}-%{version}.tar.gz
URL: http://www.opendap.org/

Group: Development/Libraries
BuildRoot:  %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
License: LGPL/BSD
# Mandrake and Fedora
BuildRequires: libdap >= 3.5.2

%description
The libnc-dap library is a call-for-call replacement for netcdf 3.5 (and
is mostly compatible with netcdf 3.6). It can read and write to and from
netcdf files on the local machine and it can read from DAP2 compatible data
servers running on local or remote machines. Data served using DAP2 need
not be stored in netcdf files to be read using this repalcement library.
Also included in this package is the ncdump utility, also bundled with the
original netcdf library, relinked with the library and thus able to read
from DAP2 compatible servers.

%package devel
Summary: Static libraries and header files from libnc-dap
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
#
%description devel
This package contains all the files needed to develop applications that
will use libnc-dap.

%prep
%setup -q
# %patch

%build
%configure
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT/%{_libdir}/*.la

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_bindir}/dncdump
%{_libdir}/libnc-dap.so.*
%doc README README.translation INSTALL NEWS COPYRIGHT

%files devel
%defattr(-,root,root,-)
%{_libdir}/libnc-dap.so
%{_libdir}/libnc-dap.a
%{_bindir}/ncdap-config
%{_includedir}/libnc-dap/
%{_datadir}/aclocal/*


%changelog
* Fri Aug 19 2005 James Gallagher <jimg@zoey.opendap.org> 3.5.2-3
- Added README.translation and INSTALL; version to 3.5.2

* Sat Jul  2 2005 Patrice Dumas <dumas@centre-cired.fr> - 3.5.1-2
- Support for shared libraries

* Mon Jun 20 2005 James Gallagher <jimg@otaku.opendap.org> 
- Initial build.
