Name: libnc-dap
Summary: The NetCDF interface to DAP-2 from OPeNDAP
Version: 3.7.1
Release: 1

Group: Development/Libraries
# ncdump, netcdf headers, lnetcdf are coverd by a BSD/MIT-like license
# but they are linked statically against libnc-dap
License: LGPLv2+
URL: http://www.opendap.org/
Source0: ftp://ftp.unidata.ucar.edu/pub/opendap/source/libnc-dap-%{version}.tar.gz 

BuildRoot:  %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: libdap-devel >= 3.8.0 gcc-gfortran
BuildRequires: pkgconfig

%description
The libnc-dap library is a call-for-call replacement for netcdf. It can 
read and write to and from netcdf files on the local machine and it can 
read from DAP2 compatible data servers running on local or remote 
machines. Data served using DAP2 need not be stored in netcdf files 
to be read using this replacement library.
Also included in this package is the ncdump utility, also bundled with the
original netcdf library, renamed dncdump, relinked with the library and 
thus able to read from DAP2 compatible servers.

%package devel
Summary: Development files and header files from libnc-dap
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: libdap-devel >= 3.8.0
Requires: pkgconfig
# for /usr/share/aclocal owning
Requires: automake

%description devel
This package contains all the files needed to develop applications that
will use libnc-dap.

%prep
%setup -q
rm -rf netcdf/.svn

%build
%configure --disable-static --disable-dependency-tracking
make %{?_smp_mflags}

%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="%{__install} -p"
rm $RPM_BUILD_ROOT%{_libdir}/*.la

mv  $RPM_BUILD_ROOT%{_bindir}/ncdap-config-pkgconfig $RPM_BUILD_ROOT%{_bindir}/ncdap-config

mv $RPM_BUILD_ROOT%{_bindir}/ncdump $RPM_BUILD_ROOT%{_bindir}/dncdump

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%{_bindir}/dncdump
%{_libdir}/libnc-dap.so.*
%doc README README.translation NEWS COPYRIGHT COPYING netcdf

%files devel
%defattr(-,root,root,-)
%{_libdir}/libnc-dap.so
%{_libdir}/pkgconfig/libnc-dap.pc
%{_bindir}/ncdap-config
%{_includedir}/libnc-dap/
%{_datadir}/aclocal/*


%changelog
* Fri Nov 24 2006 James Gallagher <jimg@zoe.opendap.org> - 3.7.0-1
- Update for 3.7.0 (64 bit support)

* Wed Sep  6 2006 Patrice Dumas <pertusus@free.fr> 3.6.2-1
- update to 3.6.2

* Tue Feb 28 2006 James Gallagher <jgallagher@opendap.org> - 3.6.0-1
- Update to 3.6.0

* Mon Nov 21 2005 Patrice Dumas <pertusus@free.fr> - 3.5.2-5
- fix Source0

* Tue Aug 30 2005 Patrice Dumas <pertusus@free.fr> - 3.5.2-4
- Add missing Requires
- remove the INSTALL file and add the netcdf directory

* Fri Aug 19 2005 James Gallagher <jimg@zoey.opendap.org> 3.5.2-3
- Added README.translation and INSTALL; version to 3.5.2

* Sat Jul  2 2005 Patrice Dumas <pertusus@free.fr> - 3.5.1-2
- Support for shared libraries

* Mon Jun 20 2005 James Gallagher <jimg@otaku.opendap.org> 
- Initial build.
