
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2002,2003 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

// (c) COPYRIGHT URI/MIT 1999
// Please read the full copyright statement in the file COPYRIGHT_URI.
//
// Authors:
//      jhrg,jimg       James Gallagher <jgallagher@gso.uri.edu>

// Interface for Float32 type.
//
// 3/22/9 jhrg9

#ifndef _float32_h
#define _float32_h 1


#ifndef _dods_datatypes_h
#include "dods-datatypes.h"
#endif

#ifndef _basetype_h
#include "BaseType.h"
#endif

#ifndef constraint_evaluator_h
#include "ConstraintEvaluator.h"
#endif

/** @brief Holds a 32-bit floating point value.

    @see BaseType
    */
class Float32: public BaseType
{
    /** This class allows Byte, ..., Float64 access to <tt>_buf</tt> to
    simplify and
    speed up the relational operators.

    NB: According to Stroustrup it does not matter where (public, private
    or protected) friend classes are declared. */
    friend class Byte;
    friend class Int16;
    friend class UInt16;
    friend class Int32;
    friend class UInt32;
    friend class Float64;

protected:
    dods_float32 _buf;

public:
    Float32(const string &n = "");

    Float32(const Float32 &copy_from);

    Float32 &operator=(const Float32 &rhs);

    virtual ~Float32()
    {}

    virtual BaseType *ptr_duplicate();

    virtual unsigned int width();

    virtual bool serialize(const string &dataset, ConstraintEvaluator &eval,
                           DDS &dds, XDR *sink, bool ce_eval = true);
    virtual bool deserialize(XDR *source, DDS *dds, bool reuse = false);

    virtual unsigned int val2buf(void *val, bool reuse = false);
    virtual unsigned int buf2val(void **val);

    virtual dods_float32 value() const;
    virtual bool set_value(dods_float32 f);

    virtual void print_val(FILE *out, string space = "",
                           bool print_decl_p = true);

    virtual bool ops(BaseType *b, int op, const string &dataset);

    virtual void dump(ostream &strm) const ;
};

#endif // _float32_h

