#include "GProperties.h"
#include <fstream>
#include <iostream>
#include <vector>
#include "../io_src/GStd_Output.h"
#include "../io_src/GError_Output.h"

using namespace GMathLib::Util;
using namespace GMathLib::IO;

GProperties::GProperties()
: GObject(), load_flag(false)
{
   Class_Name("GProperties");
}

void GProperties::Load(const std::string filename)
{
    //引数で指定されたプロパティファイルを開く
    std::ifstream ifs(filename.c_str());
    
    //エラー処理
    if(ifs.fail()){
          std::string errorinfo = "Can't open the file '" + filename + "'.";         
          GError_Output::Puts(Class_Name() + "::Load", errorinfo);
	  load_flag = false;
	  return;
    }

    //一度，マップをクリアする．
    m_map.clear();
    char tmp[256];
    
    //ファイルストリームからデータを読み込み，キーと値の組を抽出する．
    //抽出したデータをマップに保存する
    ifs.getline(tmp, 256);
    while(!ifs.eof())
    {
        std::string line(tmp);
        //コメント行は無視する
        if(line.substr(0, 1).compare("#") != 0){
            std::string::size_type nEq = line.find("=");
            if(nEq != std::string::npos){
                std::string key = line.substr(0, nEq);
		std::string val = line.substr(nEq+1);
		m_map.insert(std::pair<std::string, std::string>(key, val));

            }
	}
	ifs.getline(tmp, 256);
        
    }

    load_flag = true;
    ifs.close();
}


std::string GProperties::GetProperty(const std::string key) 
{
    
    //ファイルを正常にロードしているか確認する
    if(!load_flag){
	GError_Output::Puts(Class_Name()+"::GetProperty", "Failed to load file.");
        return std::string("");
    }
    
    //マップに対応するキーがあるかを確認する
    if(m_map.count(key) == 0){
        const std::string errinfo = "Key '" + key + "' can not be found in Key datas of properties.";
	GError_Output::Puts(Class_Name()+"::GetProperty", errinfo);
	return std::string("");
    }else{
        return m_map.find(key)->second;
    }
}

void GProperties::Print_All_Properties()
{
    PropertyMap::iterator itr = m_map.begin();
    std::vector<std::string> property_list;

    // プロパティのキーと値の情報を文字列情報にして, リスト化する
    while( itr != m_map.end()){
        property_list.push_back((*itr).first + " : " + (*itr).second);
        itr++;
    }

    // リスト情報を標準出力する
    GStd_Output::Write(Class_Name()+"::Print_All_Properties", property_list);
}

/* Test Driver */
/*
int main()
{
   GProperties prop;
   try{
       prop.Load("param.properties");
       GProperties::PropertyMap map = prop.GetAll();
       GProperties::PropertyMap::iterator itr = map.begin();
       while(itr != map.end())
       {
           std::cout << "Key : " << itr->first << ",Val: " << itr->second << std::endl;
           itr++;
       }
       std::cout << "Val: " << prop.GetProperty("qq") << std::endl;
       std::cout << "Val: " << prop.GetProperty("delta_x") << std::endl;
       
   }catch(const char* str)
   {
       std::cout << str << std::endl;
       return -1;
   }

   return 0;
}
*/
