#include "GProgress_Bar.h"
#include "io/GStd_Output.h"
#include <iostream>
#include <vector>
#include <sstream>

using namespace GMathLib::Util;
using namespace GMathLib::IO;

GProgress_Bar::GProgress_Bar()
:GObject(), now_state(0), now_timestep(0), end_timestep(-1)
{
   Class_Name("GProgress_Bar");
}

GProgress_Bar::~GProgress_Bar()
{
}

void GProgress_Bar::Prepair(int end_time_step, const std::string content)
{
    end_timestep = end_time_step;
    
    // R\[Ƀ[v\
    std::vector<std::string> list;
    std::ostringstream oss;

    oss << "Start the loop! : Total " << end_timestep << "turns";
    list.push_back(oss.str());
    list.push_back(content); 
    GStd_Output::Write(Class_Name() + "::Prepair()", list);
    
    //[vɓ钼O̎擾
    time(&start_time);
}

void GProgress_Bar::Update_Counter()
{
    int aster_num = (int) ( (now_timestep+1) * 10 / end_timestep);
    now_timestep++;

    if(now_state == aster_num){
	 return;
    }
    
    //擾
    time_t now_time;
    time(&now_time);
    
    //݂̐i󋵂oIɕ\
    std::cout << "[ ";
    for(int i=1; i <= 10; i++ ){
        if(i <= aster_num){
            std::cout << "*";
	}else{
	    std::cout << " ";
	}
    }
    std::cout << " ] ";
    std::cout << aster_num * 10 << "% : ";
    std::cout << difftime(now_time, start_time) << " s " <<  std::endl;

    //݂̐i󋵂ێĂ
    now_state = aster_num;
}

