#include "GMatrixList_Manager.h"
#include "io/GError_Output.h"

#include <sstream>
#include <string>

using namespace GMathLib;
using namespace GMathLib::Util;
using namespace GMathLib::IO;

GMatrixList_Manager::GMatrixList_Manager()
: GObject()
{
   Class_Name("GMatrixList_Manager");
}

GMatrixList_Manager::~GMatrixList_Manager()
{
    GMatrixList::iterator itr;
    itr = matrix_list.begin();
    
    // XgێĂ sIuWFNg̃|C^g, 
    // ̃NXێĂsIuWFNgSĂ. 
    while(itr != matrix_list.end()){
        delete itr->second;
        itr++;
    }
}

bool GMatrixList_Manager::register_matrix(int id, GMatrix* p_matrix)
{
    GMatrixList::iterator itr;
    itr = matrix_list.find(id);

    // id łɎgĂȂ, sIuWFNg̃|C^ map ɕۑ.
    if(itr == matrix_list.end()){
	matrix_list.insert(std::pair<int, GMatrix*>(id, p_matrix));
	return true;

    }else{
        return false;
    }

}

void GMatrixList_Manager::Register_Matrix(int id, GMatrix& mx)
{
    // ŗ^ꂽ GMatrix IuWFNgƓTCY̍sIuWFNg쐬, 
    // svfSɃRs[. 
    GMatrix* p_created_mx = new GMatrix(mx.Row(), mx.Column());
    p_created_mx->Object_Name(mx.Object_Name());
    p_created_mx->Copy(mx);

    // SɃRs[sIuWFNg register_matrix() Ăяo map ɓo^.
    // id ̏dɂo^sꍇ̓G[o͂s. 
    if(!register_matrix(id, p_created_mx)){       
	std::ostringstream oss;
	oss << id;
        std::string errorinfo = "Specified ID '" + oss.str() +"' has been previously used.";         
        GError_Output::Puts(Class_Name() + "::Register_Matrix", errorinfo);

	// o^Ɏŝō쐬sIuWFNgj. 
	delete p_created_mx;
        return;
    }
}


GMatrix* GMatrixList_Manager::Create_Register_Matrix(int id, int row, int column)
{
    // w肳ꂽsTCYsIuWFNg쐬. 
    GMatrix* p_created_mx = new GMatrix(row, column);
    
    // SɃRs[sIuWFNg register_matrix() Ăяo map ɓo^.
    // id ̏dɂo^sꍇ̓G[o͂s. 
    if(!register_matrix(id, p_created_mx)){       
	std::ostringstream oss;
	oss << id;
        std::string errorinfo = "Specified ID '" + oss.str() +"' has been previously used.";         
        GError_Output::Puts(Class_Name() + "::CreateRegister_Matrix", errorinfo);
	
	// o^Ɏŝō쐬sIuWFNgj. 
	delete p_created_mx;
        return 0;
    }

    return p_created_mx;
}

void GMatrixList_Manager::Delete_Matrix(int id)
{
    GMatrixList::iterator itr;
    itr = matrix_list.find(id);

    // id ɑΉsIuWFNg̃|C^݂邱ƂmF, 
    // ݂΂̍sIuWFNg폜. 
    if(itr != matrix_list.end()){
       // sIuWFNgj. 
       delete itr->second;
       
       // Xg id ɑΉ jsIuWFNgւ̃|C^O. 
       matrix_list.erase(id);
    }else{
	std::ostringstream oss;
	oss << id;
        std::string errorinfo = "Specified ID '" + oss.str() +"' is not found in registered IDs.";         
        GError_Output::Puts(Class_Name() + "::Delete", errorinfo);

    }

}


