#include<iostream>
#include "GMatrix.h"
#include "GVector.h"
#include "GLinear_Homo_Eq.h"
#include "util/GProgress_Bar.h"
//#include <omp>

using namespace GMathLib;
using namespace GMathLib::Util;

int main(){
	const int N = 7; 
	double d1[N*N] = {
	                  2, 1, 6, 3, 7, 8, 9,
	                  4, 3, 8, 4, 1, 1, 2,
	                  3, 2, 2.3, 4, 1, 4, 0,
	                  2, 3, 4, 6, 7.1, 3, 2,
	                  1, 1, 1, 3, 1, 6, 7,
			  2, 0, -1, 1, 2, 5, 3, 
			  4, -2, 2, 6, 5.6, 2, 1
		       }; 
	double v1[N] = {4, 3, 8, 7, 3.2, 3, 8}; 
	double v2[N] = {0, 0, 0, 0, 0, 0, 0}; 
	
	
	GMatrix *matrix1 = new GMatrix(N, N, d1);
	matrix1->Object_Name("matrix1");

	GVector *vec1 = new GVector(N, GVector::COLUMN_VECTOR, v1);
	vec1->Object_Name("vec1");
	
	GMatrix matrix1l(N, N);
	matrix1l.Copy(*matrix1);
	matrix1->Object_Name("matrix1l");

	GVector vec1l(N, GVector::COLUMN_VECTOR);
	vec1l.Copy(*vec1);
	vec1l.Object_Name("vec1l");
	
	GVector *vec2 = new GVector(N, GVector::COLUMN_VECTOR, v2);
	vec2->Object_Name("vec2");
	

	// 連立方程式ソルバのテスト
	GLinear_Homo_Eq lse_gauss;
	GLinear_Homo_Eq lse_lu;
	int loopNum = 100;

	GProgress_Bar bar1;
        bar1.Prepair(loopNum, "Gauss Ellimination loop");

	for(int i=0; i < loopNum; i++){
	    matrix1l.Copy(*matrix1); vec1l.Copy(*vec1);
	    lse_gauss.S_Gauss_Partial_Pivot(matrix1l, vec1l, *vec2);
	    
	    bar1.Update_Counter();
	}
        
	vec2->Print();

	GProgress_Bar bar2;
        bar2.Prepair(loopNum, "LU Method loop");
	
	for(int i=0; i < loopNum; i++){
	    matrix1l.Copy(*matrix1); vec1l.Copy(*vec1);

	    if(i==0){
	        lse_lu.S_LU_Partial_Pivot(matrix1l, vec1l, *vec2);
	    }else{
	        lse_lu.S_LU_Partial_Pivot(matrix1l, vec1l, *vec2, false);
	    }

	    bar2.Update_Counter();
	}
	vec2->Print();


	delete matrix1;
	delete vec1;
	delete vec2;
	
	return 0;
}
