#include "GVector.h"
#include <cmath>

using namespace GMathLib;
using namespace GMathLib::IO;

GVector::GVector()
: GMatrix()
{
    Class_Name("GVector");
}

GVector::~GVector()
{
}


GVector::GVector(int size, int vec_type, double *p_data0)
: GMatrix(1, size, p_data0)
{
    // この時点で, 派生の元の GMatrix クラスのコンストラクタを呼び出して, (1, size) のサイズの行列オブジェクトを
    // 作成しておく.

    // class name の設定
    Class_Name("GVector");
    
    // 行ベクトル, 列ベクトルのどちらを指定しているかを確認し, 行列の形をリシェイプする.
    if( vec_type == GVector::ROW_VECTOR ){
        Reshape(1, size);

    }else if( vec_type == GVector::COLUMN_VECTOR ){
        Reshape(size, 1);

    }else{
        const std::string errinfo = "Specified vector type is invalid.";
        GError_Output::Puts(Class_Name() +"::GVector",  errinfo);
    }
}


int GVector::Copy(const GVector& obj, int begin_id, int end_id, int pos)
{
    int copy_size = end_id - begin_id + 1;

    // コピーの元のインデックス範囲およびコピー先のインデックス範囲が適切かを確認する
    if(begin_id > obj.Size()-1 || end_id > obj.Size()-1 
       || pos + copy_size > Size() ){
        const std::string errinfo = "Specified range or position is inappropriate.";
        GError_Output::Puts(Class_Name() +"::Copy(GVector, int, int, int)",  errinfo);
        
	return 1;
    }

    // インデックスの範囲に問題がなければ, コピーを行う
    for(int i=0; i < copy_size; i++){
        Set(pos + i, obj.Get(begin_id + i));
    }

    return 0;
}

double GVector::Norm()
{
    int size = Size();
    double tmp = 0.0;

    // ベクトルのノルムを計算する.
    for(int i=0; i < size; i++){
        tmp += Get(i) * Get(i);
    }

    return std::sqrt(tmp);
}

double GVector::Dot_Product(GVector& vec1, GVector& vec2){
    // ベクトルの内積演算

    // 内積演算が可能なベクトルの形かを確認する.
    // vec1 が行ベクトル, vec2 が列ベクトルでなければならない.
    if( vec1.Row() == 1 && vec2.Column() == 1 ){
        double tmp =0.0;
        double size = vec1.Row();

        for(int i=0; i < size; i++){
	    tmp += vec1(i) * vec2(i);
	}

        return tmp;

    }else{
        const std::string errinfo = "Shapes of specified vector are invalid.";
        GError_Output::Puts( vec1.Class_Name() +"::Dot_Product",  errinfo);
    }

    return -1;
}


void GVector::Cross_Product(GVector& vec1, GVector& vec2){
    
    // 3 次元ベクトルかを確認する
    if( vec1.Size() == 3  &&  vec2.Size() == 3 )
    {

       // 外積を計算する.
       Set(0, vec1(1) * vec2(2) - vec1(2) * vec2(1));
       Set(1, vec1(2) * vec2(0) - vec1(0) * vec2(2));
       Set(2, vec1(0) * vec2(1) - vec1(1) * vec2(0));
       
    }else{
        const std::string errinfo = "Shapes of specified vector are invalid.";
        GError_Output::Puts( vec1.Class_Name() +"::Cross_Product",  errinfo);
    }
}

