#include "GLinear_Homo_Eq.h"
#include <iostream>
#include <sstream>
#include <cmath>
#include "../io_src/GError_Output.h"

using namespace GMathLib;
using namespace GMathLib::IO;
using namespace GMathLib::GMatrix_Util;

GLinear_Homo_Eq::GLinear_Homo_Eq()
: GObject(), p_lu(0)
{
    Class_Name("GLinear_Homo_Eq");
}

GLinear_Homo_Eq::~GLinear_Homo_Eq()
{
    if(p_lu != 0){
        delete p_lu;
    }
}

/*
 * s{bgIsKEX̏@pAꎟ\o
 */
void GLinear_Homo_Eq::S_Gauss_Partial_Pivot(const GMatrix& matrix, const GVector& vec, GVector& answer_vec){
	GMatrix matrix_copy = matrix;
	GVector vec_copy = vec;
	
	S_Gauss_Partial_Pivot(matrix_copy, vec_copy, answer_vec);
}

void GLinear_Homo_Eq::S_Gauss_Partial_Pivot(GMatrix& A, GVector& b, GVector& x)
{
        // ^ꂽsxNǧ`KmF
	if( !check_matrix_size(A, b, x) ){
	    std::string errorinfo = "Matrix or vector size is invalid !";
	    GError_Output::Puts(Class_Name() + "::S_Gauss_Partial_Pivot", errorinfo);
		
	    return;
	}
	
	const double TINY = 1.0e-10;
	int n = b.Size();
	int status = 0;
	int pk, max_p, pj;
	int *p = new int[n];
	double max, aik;
	double pivot, multi, sum;
			
	//s{bgԍZbg
	for(int k = 0; k < n; k++)
	    p[k] = k;
		
	    for(int k = 0; k < n - 1; k++){
		
	    //vf̍őls{bgs𒲂ׂ
	    pk = p[k]; max = 0.0;	max_p = k;		
	    for(int i = k; i < n; i++){
	        aik = A(p[i], k);

	        if(std::abs(aik) > max){
		    max = std::abs(aik);
		    max_p = i;
		}
	    }
			
	    //ől臒l菬ꍇ́C[vo
	    if(max <= TINY){
	        status = 8; break;
	    }
			
	    //s{bg
	    if(max_p != k){
	        p[k] = p[max_p]; p[max_p] = pk; pk = p[k];
	    }
			
	    //Oi
	    pivot = 1.0 / A(pk, k);
	    for(int j = k +1; j < n; j++){
	        pj = p[j];
	        multi = A(pj, k) * pivot;
				
	        if(std::abs(multi) > TINY){
		    for(int i = k + 1; i < n; i++)
	                A(pj, i) = A(pj, i) - multi * A(pk, i);
						
			b(pj) = b(pj) - multi * b(pk);
		}else{
		    A(pj, k) = 0.0;
		}
	    }
	}
		
	//G[
		
	//iŎg鐔臒lȂmF
	if(std::abs( A(p[n-1], n -1) ) < TINY)
	    status = 9;
	        
	//肪ꍇ̓G[o͂
	if(status != 0){
            std::ostringstream oss;
	    oss << status;
	    std::string errorinfo = "GAUSS, Failed! The system is singular! STATUS : " + oss.str();
	    GError_Output::Puts(Class_Name() + "::S_Gauss_Partial_Pivot", errorinfo);
         }else{

	    //in߂
	    x(n-1) = b(p[n-1]) / A(p[n-1], n-1);
	    for(int k = n - 2; k >= 0; k--){
	        pk=p[k]; sum = b(pk);
		for(int i = k + 1; i < n; i++)
		    sum = sum - A(pk, i) * x(i);
				
		x(k) = sum / A(pk, k);	
	    }
	}
		
	delete p;			
}


/*
 * s{bgIэs̃XP[Os LU ɂAꎟ\o
 */
void GLinear_Homo_Eq::S_LU_Partial_Pivot(GMatrix& matrix, GVector& vec, GVector& answer_vec, bool do_lu_cmp_flag)
{
    // ^ꂽsxNǧ`KmF
    if( !check_matrix_size(matrix, vec, answer_vec) ){
        std::string errorinfo = "Matrix or vector size is invalid !";
	GError_Output::Puts(Class_Name() + "::S_LU_Partial_Pivot", errorinfo);
		
	return;
    }
    
    GMatrix* p_Alu = 0;
    GMatrix* p_P = 0;
    int n = matrix.Row();

    // GLU_Composition ̃NXIuWFNg܂ĂȂꍇ͂܂. 
    if(p_lu == 0){
        p_lu = new GLU_Composition();
    }

    // do_lu_cmp_flag ^Ȃ, LU Ȃ
    if(do_lu_cmp_flag){
        p_lu->LU_Composition(matrix, GLU_Composition::LU_COMBINED);
    }else{
        if( p_lu->Get_LU() == 0){
            std::string errorinfo = "Specify do_lu_cmp_flag=true !";
	    GError_Output::Puts(Class_Name() + "::S_LU_Partial_Pivot", errorinfo);
		
	    return;
        }
    }

    // LU ̌ʂђus̎擾
    p_Alu = p_lu->Get_LU();
    p_P = p_lu->Get_P(); 
    
    // LU ̍ۂ̍suusg, 
    // Eӂ̗xNgւ
    GVector b(n);
    b.Multi(*p_P, vec);
    
    // A  L, U gĘẢ߂
    // A x = b, A=LU
    // L y = b, U x = y
    double sum;

    // ܂Oiɂ y ߂
    answer_vec(0) = b(0);
    
    for(int i=1; i < n; i++){
        sum = 0.0;
	for(int j=0; j <= i-1; j++){
	    sum += (*p_Alu)(i, j) * answer_vec(j); 
	}

	answer_vec(i) = b(i) - sum;
    }
    
    // Čޏɂ x ߂
    answer_vec(n-1) = answer_vec(n-1) / (*p_Alu)(n-1, n-1);

    for(int i=n-2; i >= 0; i--){
        sum = 0.0;
	for(int j=i+1; j < n; j++){
	    sum += (*p_Alu)(i, j) * answer_vec(j);
	}

	answer_vec(i) = ( answer_vec(i) - sum ) / (*p_Alu)(i, i);
    }
}

bool GLinear_Homo_Eq::check_matrix_size(GMatrix& matrix, GVector& vec, GVector& answer_vec)
{
    if(matrix.Column() != matrix.Row()){         // Ws͐sł邩
        return false;
    }else if( matrix.Row() != vec.Row()){        // Wsƒ萔̃xNg̍s͈v邩
        return false;
    }else if( matrix.Row() != answer_vec.Row()){ // WsƓi[xNg̍s͈v邩
        return false;
    }else if( vec.Shape() != GVector::COLUMN_VECTOR
       || answer_vec.Shape() != GVector::COLUMN_VECTOR ){ // xNg͗xNgł邩
	return false;
    }else{
        return true;
    }
}
