#ifndef GCUBIC_SPLINE_INTERPOL_H
#define GCUBIC_SPLINE_INTERPOL_H

#include "GObject.h"
#include "GMatrix.h"
#include "GVector.h"
#include "GLinear_Homo_Eq.h"

namespace GMathLib{

/**
 * 3次多項式の各項の係数を保持する構造体
 */
struct GCubicFncData
{
    //S_i = a_i*x_i^3 + b_i*x_i^2 + c_i*x_i + d_i 
    double a; /**< 3次の項の係数　*/
    double b; /**< 2次の項の係数　*/
    double c; /**< 1次の項の係数　*/
    double d; /**< 定数項　　　　*/
};

/**  
 * 3次(自然)スプライン補間クラス
 * 離散化されたデータをもとに3次多項式で小区間の曲線を近似することを目的にしたクラス．
 * 全N+1個の格子点の間で決定されるN個の3次多項式を行列として取り扱う．
 * 各格子間で決められる3次関数のデータ（各次数の係数）は，構造体GCubicFncDataによって管理する．
 */
class GCubic_Spline_Interpolation : public GObject
{
public:
    /**
     * コンストラクタ
     */
    GCubic_Spline_Interpolation();
    
    /**
     * デストラクタ
     */
    ~GCubic_Spline_Interpolation();
    
    /**
     * 対象区間の格子点総数を指定し，補完に必要なメモリを確保する関数．
     * DoInterpolation()を呼び出す前に必ず1度は，呼び出されなければならない．
     * 作成したGCubic_Spline_Interpolationオブジェクトを使いまわす場合は，再度呼び出さなくてもよい．
     * @see DoInterpolation()
     * @param gridp_num 対象区間に存在する格子点数
     */
    void Prepair(int gridp_num);


    /**
     * 3 次スプライン補間を行い，各小区間において3次多項式を作成する関数
     * 作成した 3 次多項式のデータ配列は，GCubicFncData 配列に格納される．
     * この関数を呼び出す前に，少なくとも一度は Prepair() を呼び出さなければならない．
     * @see Prepair()
     * @see GetCubicFuncData()
     * @param discre_mx 離散化データを表す，N+1 行 * (x, y)（２列）のGMatrixオブジェクト
     * @return 成功すれば0，失敗すれば1を返す
     */
    int DoInterpolation(GMatrix& discre_mx);
   

    /**
     * 3 次スプライン補間の計算結果を取得する関数
     * 計算結果の3次多項式のデータ配列は GCubicFncData 配列格納されており，そのポインタが返される．
     * @see DoInterpolation()
     * @return 3 次スプライン補間の結果を保持する GCubicFncData 配列のポインタ
     */
    GCubicFncData* GetCubicFuncData(){
        return p_cfData;
    }

private:
    GCubicFncData* p_cfData;
    GMatrix* p_at;
    GVector* p_u;
    GVector* p_v;
    GVector* p_h;
    GLinear_Homo_Eq ln_hm_solver;

};

}
#endif

