#include "GCIP_Method_Calc2D.h"
#include "GMatrix.h"
#include "GDiff_Util.h"
#include <iostream>
#include <omp.h>

using namespace GMathLib;
using namespace GMathLib::GDiff_Util;

GCIP_Method_Calc2D::GCIP_Method_Calc2D()
: GObject(), listener(0), phys_mx1(0), phys_mx2(0), diff_mx1_x(0), diff_mx2_x(0), diff_mx1_y(0), diff_mx2_y(0),
vel_u_mx(0), vel_v_mx(0)
{
    Class_Name("GCIP_Method_Calc2D");
}

GCIP_Method_Calc2D::~GCIP_Method_Calc2D()
{
    if(phys_mx1 != 0){
       delete phys_mx1;
       delete phys_mx2;
       delete diff_mx1_x;
       delete diff_mx2_x;
       delete diff_mx1_y;
       delete vel_u_mx;
       delete vel_v_mx;
    }
}


void GCIP_Method_Calc2D::Prepair(GCIP2D_Param& param, GMatrix& init_phys_mx, GMatrix& init_vel_u_mx, GMatrix& init_vel_v_mx)
{
    pm = param;

    if(phys_mx1 != 0){
       delete phys_mx1;
       delete phys_mx2;
       delete diff_mx1_x;
       delete diff_mx2_x;
       delete diff_mx1_y;
       delete vel_u_mx;
       delete vel_v_mx;
    }
    
    //CIP@ɕKvȌvZpm
    phys_mx1 = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
    phys_mx2 = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
    diff_mx1_x = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
    diff_mx2_x = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
    diff_mx1_y = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
    diff_mx2_y = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
    
    vel_u_mx = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
    vel_v_mx = new GMatrix(pm.gridp_num_x, pm.gridp_num_y);
 
    //mۂsIuWFNgɏlݒ
    phys_mx2->Copy(init_phys_mx);
    vel_u_mx->Copy(init_vel_u_mx);
    vel_v_mx->Copy(init_vel_v_mx);


    //ʂ̋ԔlvZ
    //x̋Ԕi, Ej
    for(int j=0; j < pm.gridp_num_y; j++){   
       for(int i=1; i < pm.gridp_num_x-1; i++){
	    diff_mx2_x->Set(i, j, 
	           ( (*phys_mx2)(i+1, j) - (*phys_mx2)(i-1, j) ) / ( 2.0 * pm.del_x ) ); 
	}

	diff_mx2_x->Set(0, j,  
	          ( (*phys_mx2)(1, j) - (*phys_mx2)(pm.gridp_num_x-1, j) ) / ( 2.0 * pm.del_x ) ); 
	diff_mx2_x->Set(pm.gridp_num_x-1, j,  
	          ( (*phys_mx2)(0, j) - (*phys_mx2)(pm.gridp_num_x-2, j) ) / ( 2.0 * pm.del_x ) ); 
   }
   

    //y̋ԔiCEj
    for(int i=0; i < pm.gridp_num_x; i++){
        for(int j=1; j < pm.gridp_num_y-1; j++){
	    diff_mx2_y->Set(i, j,   
	            ( (*phys_mx2)(i, j+1) - (*phys_mx2)(i, j-1) ) / ( 2.0 * pm.del_y ) ); 
	}

	diff_mx2_y->Set(i, 0,  
	        ( (*phys_mx2)(i, 1) - (*phys_mx2)(i, pm.gridp_num_y-1) ) / ( 2.0 * pm.del_y ) ); 
	diff_mx2_y->Set(i, pm.gridp_num_y-1, 
	        ( (*phys_mx2)(i, 0) - (*phys_mx2)(i, pm.gridp_num_y-2) ) / ( 2.0 * pm.del_y ) ); 
    }

}
    
    
void GCIP_Method_Calc2D::Update_Velocity_Field(GMatrix& updated_vel_u_mx, GMatrix& updated_vel_v_mx)
{
     vel_u_mx->Copy(updated_vel_u_mx);
     vel_v_mx->Copy(updated_vel_v_mx);
}
    
void GCIP_Method_Calc2D::Proceed_TimeStep()
{
    //x,ÿڗvZ
    calc_advect_phase_2D();


    //ڗvZp̃Xi[NXiGNonAdvect_Phase2D_Listenerjo^Ăꍇ́C
    //ڗvZ邽߂ɃCxg𔭐
    if(listener != 0){
        listener->Proceed_NonAdvect2D_Phase(
            *phys_mx1,*diff_mx1_x, *diff_mx1_y, 
	    *phys_mx2, *diff_mx2_x, *diff_mx2_y,
	    *vel_u_mx, *vel_v_mx, pm);
    }else{
        //ڗo^ĂȂꍇ́CœYP̕ϐYQ̕ϐɒlRs[C
	//f[^XV
	phys_mx2->Copy(*phys_mx1);
	diff_mx2_x->Copy(*diff_mx1_x);
	diff_mx2_y->Copy(*diff_mx1_y);
    }
}

void GCIP_Method_Calc2D::calc_advect_phase_2D()
{   
    double c30, c20, c03, c02, c12, c21, c11;

    int is, js;
    int im, jm;
    double xX, yY;
    int i, j;
    double del_x = pm.del_x;
    double del_y = pm.del_y;
    double delx, dely;
    double delt = pm.del_t;
    int gp_x = pm.gridp_num_x;
    int gp_y = pm.gridp_num_y;

    
    //ڗŌvZꂽl͍sIuWFNg̓Y1̂قɑD
    //Ȃ̂łŎgf[^͍sIuWFNg2̂قł
   #pragma omp parallel for  private (i, c30, c20, c03, c02, c12, c21, c11, is, js, im, jm, xX, yY, delx, dely) firstprivate(delt, gp_x, gp_y, del_x, del_y)
    for(j=0; j < gp_y; j++){
	for(i=0; i < gp_x; i++){
            
	    xX = - delt * (*vel_u_mx)(i, j);
	    yY = - delt * (*vel_v_mx)(i, j);

	    //̕
	    if(xX > 0.0){
	        is = - 1;
            }else{
	        is = 1;
	    }

	    if(yY > 0.0){
	        js = - 1;
            }else{
	        js = 1;
	    }
	    
	    im = i - is; jm = j - js;
            delx = - is * del_x;
	    dely = - js * del_y;
            
            //El
	    if(im == -1){
	        im = gp_x - 1;
	    }else if(im == gp_x){
	        im = 0;
	    }
	    
	    if(jm == -1){
	        jm = gp_y - 1;
	    }else if(jm == gp_y){
	        jm = 0;
	    }

	    //svf擾Ă
            double f_i_j = (*phys_mx2)(i, j);
	    double fx_i_j = (*diff_mx2_x)(i, j);
            double fy_i_j = (*diff_mx2_y)(i, j);
            
	    double f_im_j = (*phys_mx2)(im, j);
            double fx_im_j = (*diff_mx2_x)(im, j);
            double fy_im_j = (*diff_mx2_y)(im, j);
            
	    double f_i_jm = (*phys_mx2)(i, jm);
            double fx_i_jm = (*diff_mx2_x)(i, jm);
            double fy_i_jm = (*diff_mx2_y)(i, jm);
            
	    double f_im_jm = (*phys_mx2)(im, jm);
	    
            double f_4 = f_i_j - f_i_jm - f_im_j + f_im_jm;
            double fy_2 = fy_im_j - fy_i_j;

	    //⊮3֐̌WvZ
	    c30 = ( 
	         - ( fx_im_j + fx_i_j ) * delx - 2.0 * ( f_i_j - f_im_j ) 
		 ) / ( delx * delx * delx);
	    
	    c03 = ( 
	         - ( fy_i_jm + fy_i_j ) * dely - 2.0 * ( f_i_j - f_i_jm )
		) / ( dely * dely * dely);

	    c21 = (
	           f_4 - (fx_i_jm - fx_i_j ) * delx
		  ) / ( delx * delx  * dely );

	    c12 = (
	           f_4 - fy_2 * dely
		  ) / ( delx * dely * dely );
            
	    c20 = (
	           3.0 * ( f_im_j - f_i_j )  - ( fx_im_j + 2.0 * fx_i_j ) * delx
		  ) / ( delx * delx );

	
            c02 = (
	         3.0 * ( f_i_jm - f_i_j ) - ( fy_i_jm + 2.0 * fy_i_j ) * dely
		) / ( dely * dely );

	    c11 = - (
	             - fy_2 + c21 * ( delx * delx )
		    ) / delx;
	    
	    //ʒũf[^gāC1^CXebṽ̕f[^vZ
	    phys_mx1->Set(i, j,  
	                 ( ( c30 * xX + c21 * yY + c20 ) * xX + c11 * yY + fx_i_j ) * xX  
	                          + ( ( c03 * yY + c12 * xX + c02 ) * yY + fy_i_j ) * yY + f_i_j
		      );
	
	    diff_mx1_x->Set(i, j,
	                   ( 3.0 * c30 * xX + 2.0 * (c21 * yY + c20) ) * xX + ( c12 * yY + c11 ) * yY + fx_i_j
		        );

	    diff_mx1_y->Set(i, j, 
	                    ( c21 * xX + c11 ) * xX + ( 3.0 * c03 * yY + 2.0 * ( c12 * xX +  c02) ) * yY + fy_i_j
			);
        
	}
    }

}

