#include "GCIP_CSL_Calc1D.h"
#include <cmath>
#include <iostream>

using namespace GMathLib;

GCIP_CSL_Calc1D::GCIP_CSL_Calc1D()
: GCIP_Method_Calc1D(), integ_mx(0), dinteg_mx(0)
{
    Class_Name("GCIP_CSL_Calc1D");
}

GCIP_CSL_Calc1D::~GCIP_CSL_Calc1D()
{
    if(integ_mx != 0){
        delete integ_mx;
	delete dinteg_mx;
    }
 
}


void GCIP_CSL_Calc1D::Prepair(GCIP1D_Param& param, GVector& init_phys_mx, GVector& init_vel_mx)
{
    //スーパークラスのGCIP_Method_Calc1D::Prepair()を呼び出し，
    //パラメータ・物理量初期データ・速度場初期データをprotectedな変数にコピーして保持する．
    GCIP_Method_Calc1D::Prepair(param, init_phys_mx, init_vel_mx);

    //CIP-CSL法用のために小区間の積分値データを保持する行列オブジェクトを作成する．
    int size = init_phys_mx.Size();

    if(integ_mx != 0){
	delete integ_mx;
    }

    integ_mx = new GVector(size);
    dinteg_mx = new GVector(size);

    //初期状態における小区間の積分値データを台形公式で求める．
    for(int i=0; i < size - 1; i++){
        integ_mx->Set(i, ( (*phys_mx2)(i) + (*phys_mx2)(i + 1) ) * pm.del_x / 2);
    }
}

void GCIP_CSL_Calc1D::calc_advect_phase()
{

    double delx;
    double a, b, c, integ;
    int iup;
    double X;

    //移流相で計算された値は行列オブジェクトの添字1のほうに代入する．
    //なのでここで使われるデータは行列オブジェクト2のほうである
    
    #pragma omp parallel for private (a, b, c, integ, X, iup, delx)
    for(int i=0; i < pm.gridp_num; i++){
        if(vel_mx->Get(i) >= 0){
            iup = i - 1;
	    delx = - pm.del_x;

            integ = (*integ_mx)(iup);
	    if(iup == -1){ 
	        iup = pm.gridp_num - 1;
	        integ = (*integ_mx)(pm.gridp_num -2);
	    }


	}else{
	    iup = i + 1;
	    delx = pm.del_x;
	
	    integ = - (*integ_mx)(i);
	    if(iup == pm.gridp_num){ 
	        iup = 0;
	        integ = - (*integ_mx)(0);
	    }

	}

	a = - 5.0 * ( 6.0 * ( (*phys_mx2)(iup) + (*phys_mx2)(i) ) * delx 
	          - ( (*diff_mx2)(iup) - (*diff_mx2)(i) ) * (delx * delx )
		  + 12.0 * integ
	         ) / ( 2.0 * std::pow(delx, 5) );

	b = 4 * ( ( 7.0 * (*phys_mx2)(iup) + 8.0 * (*phys_mx2)(i) ) * delx
	          - ( (*diff_mx2)(iup) - 1.5 * (*diff_mx2)(i) ) * ( delx * delx ) 
		  + 15.0 * integ
	        ) / std::pow(delx, 4);

        c = - 3.0 * ( ( 8.0 * (*phys_mx2)(iup) + 12.0 * (*phys_mx2)(i) ) * delx 
	            - ( (*diff_mx2)(iup) - 3.0 * (*diff_mx2)(i) ) * ( delx * delx )
		    + 20.0 * integ
		  ) / ( 2.0 * std::pow(delx, 3) );

	X = - (*vel_mx)(i) * pm.del_t;

	phys_mx1->Set(i,  
	             ( ( ( a * X + b ) * X + c ) * X + (*diff_mx2)(i) ) * X + (*phys_mx2)(i) );
        diff_mx1->Set(i,
	              ( ( 4 * a * X + 3 * b) * X + 2 * c ) * X + (*diff_mx2)(i)); 
	dinteg_mx->Set(i, 
	              - ( ( ( ( a * X / 5 + b / 4 ) * X + c / 3 ) * X + (*diff_mx2)(i) / 2.0 ) * X + (*phys_mx2)(i) ) * X);

   }

   //積分値の更新
   for(int i=0; i < pm.gridp_num-1; i++){
       integ_mx->Set(i,
                     (*integ_mx)(i) + (*dinteg_mx)(i) - (*dinteg_mx)(i+1));
   }
}


