#ifndef GERROR_OUTPUT_H
#define GERROR_OUTPUT_H

#include <iostream>
#include <vector>
#include <string>

namespace GMathLib{
namespace IO{
/**
 * GMathLib内で文字列情報を出力したいときに，共通のフォーマットで標準出力するためのインライン関数の定義する名前空間
*/
namespace GStd_Output{

/**
 * GMathLibに含まれるクラス内で標準出力を行いたい場合に，標準的に呼ばれるべき標準出力関数．標準出力する内容だけでなく，標準出力を行ったクラス名，関数名も情報として出力する．
 * @param class_method 標準出力を要求するクラス名と関数名（書式はGMathLib::HogeHoge::hoge()）
 * @param output_content 出力内容
 */
inline void Write(const std::string class_method, const std::string output_content){
     std::cout << "== GMathLib Info : " << class_method << std::endl;
     std::cout << " * " + output_content << std::endl;
     std::cout << std::endl;
}

/**
 * GMathLibに含まれるクラス内で箇条書き的な標準出力を行いたい場合に，標準的に呼ばれるべき標準出力関数．標準出力する内容だけでなく，標準出力を行ったクラス名，関数名も情報として出力する．
 * 箇条書きする各行の文字列を std::vector にセットし, 第 2 引数として与える. 
 * @param class_method 標準出力を要求するクラス名と関数名（書式はGMathLib::HogeHoge::hoge()）
 * @param output_content_list 箇条書きする各行の文字列( std::string 型)をリストとして保持する std::vector オブジェクト
 */
inline void Write(const std::string class_method, std::vector<std::string> output_content_list){
     std::cout << "== GMathLib Info : " << class_method << std::endl;
     
     std::vector<std::string>::iterator itr = output_content_list.begin();
     while(itr != output_content_list.end()){
         std::cout << " * " + *itr << std::endl;
	 ++itr;
     }

     std::cout << std::endl;
}

}
}
}


#endif
