#ifndef GERROR_OUTPUT_H_
#define GERROR_OUTPUT_H_

#include <iostream>
#include <string>

namespace GMathLib{
namespace IO{
/**
 * GMathLib内で起こったエラーを，共通のフォーマットでエラー出力するためのインライン関数の定義する名前空間
*/
namespace GError_Output{

/**
 * GMathLibに含まれるクラス内でエラーが生じた場合に，標準的に呼ばれるべきエラー出力関数．エラーの内容だけでなく，エラーが発生したクラス名，関数名も情報として出力する．
 * @param class_method エラーが生じたクラス名と関数名（書式はGMathLib::HogeHoge::hoge()）
 * @param outputinfo エラーの内容
 */
inline void Puts(const std::string class_method, const std::string outputinfo){
     std::cerr << "== GMathLib Error Info : " << class_method << std::endl;
     std::cerr << " * " + outputinfo << std::endl;
     std::cerr << std::endl;
}

} //end GError_Output

} // end IO
} //end GMathLib
#endif
