#ifndef GGDF_CONSTANTS
#define GGDF_CONSTANTS

namespace GMathLib{
namespace GFD{


/*
 * 地球流体力学に特化した,物理定数およびパラメータを表現する名前空間.
 * 基本的にその値は,
 */
namespace GConstants{

/**
 * 場所や状況に依存しない物理定数(万有定数)を表現する名前空間.
 */
namespace Universal{
    const double G = 6.673e-11;      /**< 万有引力定数 [N m^2 / kg^2].
                                          Gravitational constant. */

    const double R_Unv = 8.314e03;   /**< 普遍気体定数 [J/(K * kmol)].
                                          Universal gas constant. */
}

/**
 * 地球における物理定数,パラメータを表現する名前空間.
 */
namespace Earth{
    const double Omega = 7.292e-05;          /**< 地球の自転角速度 [rad s^(-1)].
                                                Earth's angular speed of rotaion. */
    
    const double Earth_Radius = 6.37e06;   /**< 地球の平均半径 [m].
                                                Mean radius of the earth. */
    
    const double Cp_dry = 1004.6;          /**<  乾燥大気の定圧比熱 [J/(K * kg)].
                                                 Specific heat of dry air at constant pressure. */

    const double Cv_dry = 717;             /**< 乾燥大気の定積比熱  [J/(K * kg)].
                                                Specific heat of dry air at constant volume. */

    const double R_dry = 287.04;            /**< 乾燥大気の気体定数 [J/(K * kg)].
                                                 Gas constant for dry air. */
}

} // end namespace GConstants

} // end namespace GFD

} // end namespace G　MathLib
#endif
