#ifndef GPROGRESS_BAR_H
#define GPROGRESS_BAR_H

#include <string>
#include <time.h>
#include "gmathcore/GObject.h"

namespace GMathLib{
namespace Util{

/**
 * 計算に時間がかかる逐次計算ループの進捗状況をコンソールへ視覚的に表示するためのクラス
 */
class GProgress_Bar : public GObject
{
public:
    /**
     * コンストラクタ
     */
    GProgress_Bar();

    /**
     * デストラクタ
     */
    ~GProgress_Bar();

    /**
     * GProgress_Barクラス を使って進捗状況を表示するために必要な情報をセットする関数.
     * 逐次計算ループに入る直前で呼び出されなければならない.
     * 引数としては逐次計算ループの全ループ回数と，そのループ内で何を計算しているかのテキスト情報を指定する．
     * @param end_time_step 逐次計算を行う全ループ回数
     * @param content ループ内で何を逐次計算しているかを説明するテキスト情報
     */
    void Prepair(int end_time_step, const std::string content);

    /**
     * GProgress_Bar クラス内で保持している現在のループカウンタを更新するための関数
     * 逐次計算ループ内にこの関数が，埋め込まれなければならない．
     */
    void Update_Counter();

private:
   int now_state;
   int now_timestep;
   int end_timestep;
   time_t start_time;
};

}
}
#endif
