#ifndef GOBJECT_H
#define GOBJECT_H

#include <string>
namespace GMathLib{

//class GString;

/**
 * GMathLib の諸クラスは, この GObject クラスを基底クラス
 * にとして派生する.
 */
class GObject{

public:
    /**
     * コンストラクタ
     */
    GObject();

    /**
     * デストラクタ
     */
    virtual ~GObject();

    /**
     * オブジェクトの名前を設定する関数.
     * @param name 設定したいオブジェクトの名前
     */
    virtual void Object_Name(std::string name){
         obj_name = name;
    }

    /**
     * オブジェクトの名前を取得する関数.
     * @return オブジェクトの名前.
     */
    virtual std::string Object_Name(){
         return obj_name;
    }
    

    /**
     * クラス名(このクラスを派生している場合は, そのサブクラス名)を取得する関数.
     * @return クラス名.
     */
    std::string Class_Name(){
         return class_name;
    }

    /**
     * クラスのインスタンスの説明テキスト文字列を生成する関数.
     */
    virtual std::string ToString(){
        std::string text;

	text  = "Class Name: " + class_name + "\n";
	text += "Object Name: " + obj_name + "\n";

	return text;
    }

protected:

    /**
     * クラス名を設定する関数.
     * このクラスを継承したクラスは, この関数で自分のクラス名を登録する.
     * @classname 設定したいクラス名
     */
    void Class_Name(std::string classname){
         class_name = classname;
    }


private:
    std::string obj_name; /**< このオブジェクトの名前を保持する変数 */
    std::string class_name; /**< このクラス名(派生クラス)を保持する変数 */
};

}

#endif
