#ifndef GMatrix_UTIL_H
#define GMatrix_UTIL_H

#include "GObject.h"
#include "GMatrix.h"
#include "io/GError_Output.h"
#include <string>

namespace GMathLib
{

/**
 * GMatrix を使って表現される行列オブジェクトの操作に役立つ関数やクラスを定義する
 * 名前空間
*/
namespace GMatrix_Util{

/**
 * 引数に与えられた行列オブジェクトを単位行列にする関数
 * @see GMatrix
 * @param mx 単位行列にしたい行列オブジェクトの参照
 */
inline void Identity_Matrix(GMatrix& mx){
    int column = mx.Column();
    int row = mx.Row();
    
    //正方行列でない場合はエラーを出力する
    if( column != row ){
        const std::string context = "A given matrix is not a square matrix.";
        IO::GError_Output::Puts("GMatrix_Util::Identity_Matrix", context);   

    }else{
        //行列を単位行列に書き換える
	for(int i = 0; i < row; i++){
	    for(int j=0; j < column; j++){
	        if(i == j){
		    mx.SetElement(i, j, 1);
		}else{
		    mx.SetElement(i, j, 0);
		}
	    }
	}

    }
}

} //end namespace GMatrix_Util
} //end namespace GMathLib

#endif
