!= Sample program for gtool_history/gtool5
!
! * 2007/06/25 M.Odaka
! * 2006/10/25 Y.Morikawa
! * 2003/08/21 M.Odaka
! * 2001/02/27 S.Takehiro
!
! Solving diffusion equation
! \[
!     du/dt = \kappa d^2 u/dx^2
! \]
! for giving values of $u$ at $x=[0,1]$.
!
program diffusion_5

  use gtool_history                                   ! Access module (⥸塼)
  use dc_types, only : DP                           ! Access module (⥸塼)
  use dc_clock, only : CLOCK, Create, Close, Start, &
    &            Stop, Result, Predict, operator(+) ! Access module (⥸塼)

  integer, parameter     :: nx=30                   ! Grid number (åɿ)
  integer, parameter     :: nt=200                  ! Time step number (֥ƥå׿)
  integer, parameter     :: ndisp=10                ! Output interval (ϴֳ)
  real(DP), parameter    :: dx=1.0/(nx-1)           ! Grid interval (åɴֳ)
  real(DP), parameter    :: dt=0.0005               ! Time step (ֳִ)
  real(DP), dimension(nx):: x=(/(dx*(i-1),i=1,nx)/) ! X coordinate (ɸѿ)
  real(DP), dimension(nx):: temp                    ! Temperature ()
  real(DP), parameter    :: kappa=1.0               ! Diffusion coefficient (ǮȻ)
  type(CLOCK)            :: clock_init, clock_loop  ! Variable for CPU time counting 
                                                    ! CPU ַ¬ѿ

  call Create( clk = clock_init, &                  ! Initialize ()
    &          name = 'initialization' )
  call Create( clk = clock_loop, &                  ! Initialize ()
    &          name = 'time-integration' )

  call Start( clk = clock_init )                    ! Start CPU time counting
                                                    ! (CPU ַ¬)

  tinit = 0.0                                       ! Set initial time 
                                                    ! ()
    
  temp = exp(-((x-0.5)/0.1)**2)                     ! Set initial value 
                                                    ! ()

  call HistoryCreate( &                             ! Create output file 
    & file='diffusion_5.nc', &                      ! (ҥȥ꡼)
    & title='Diffusion equation',                        &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/nx,0/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m','s'/),                                 &
    & origin=real(tinit), interval=real(ndisp*dt) )

  call HistoryPut('x',x)                            ! Output 'x' (ѿ)

  call HistoryAddVariable( &                        ! Set output variable
    & varname='temp', dims=(/'x','t'/), &           ! (ѿ)
    & longname='temperature', units='K', xtype='double')

  call HistoryAddAttr('temp','gt_graph_tick_all',1)
  call HistoryAddAttr('temp','gt_graph_contour_spacing',(/0.0,1.0,0.01/))
  call HistoryAddAttr('temp','+gt_user_davis_kappa',kappa)

  call HistoryPut('temp',temp)                      ! Output 'temp (ѿ)

  call Stop( clk = clock_init )                     ! Stop CPU time counting
                                                    ! (CPU ַ¬λ)

  do it=1,nt
    call Start ( clk = clock_loop )                 ! Start CPU time counting
                                                    ! (CPU ַ¬)

    temp(2:nx-1) = temp(2:nx-1) &                   ! Time integration (ʬ)
      & + kappa*(temp(3:nx)-2*temp(2:nx-1)+temp(1:nx-2))/dx**2*dt

    if ( mod(it,ndisp) == 0 ) then
      call HistoryPut('temp',temp)                  ! Output 'temp' (ѿ)
    endif

    call Stop( clk = clock_loop )                   ! Stop CPU Time counting
                                                    ! CPU ַ¬λ

    call Predict( clk = clock_init + clock_loop, &  ! Estimate remaining time
      &            progress = real(it)/real(nt) )   ! (Ĥ֤ͽ¬)

  end do

  call HistoryClose

  call Result( clks = (/clock_init, clock_loop/), & ! Display total CPU time
    &          total_auto = .true. )                ! ( CPU ֤ɽ) 

  call Close( clk = clock_init )                    ! Finalize ()
  call Close( clk = clock_loop )                    ! Finalize ()

  stop
end program diffusion_5
