!== dc_message.f90 - åν
!
! Authors::   Yasuhiro MORIKAWA, Masatsugu ODAKA
! Version::   $Id: dc_message.F90,v 1.4 2008-10-22 04:50:59 morikawa Exp $
! Tag Name::  $Name: gtool5-20081021 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!

module dc_message
  !
  !== Overview
  !
  !åνϤԤΥ֥롼󷲤ĥ⥸塼Ǥ
  !{dcl  MSGDMP.f}[http://www.gfd-dennou.org/arch/dcl/dcl-f77doc/rc1/math1/node26.html]
  !ξ̸ߴȤƤѤ뤳ȤꤷƤޤ
  !ߡ֤ɸϤ˸ꤵƤޤ
  !
  !
  !== Output Form
  !
  ! ܥ⥸塼Υ֥롼ˤäưʲΤ褦ʷΥå
  ! Ϥޤ
  !
  !    
  !    *** MESSAGE [where] ***  message
  !    
  !    *** WARNING [where] ***  message
  !    
  !    *** ERROR (Code number) [where] *** message
  !
  implicit none
#ifdef LIB_MPI
  ! MPI 饤֥
  ! MPI library
  !
  include 'mpif.h'
#endif

  private
  public:: MessageNotify
  public:: MessageSuppressMPI

  interface MessageNotify
    module procedure MessageNotifyC
    module procedure MessageNotifyI
  end interface

  interface MessageSuppressMPI
    module procedure MessageSuppressMPI0
  end interface

  integer, save:: output_rank = -1
#ifdef LIB_MPI
  integer, save:: save_myrank = -1
#endif

contains

  subroutine MessageNotifyC(level, where, message, &
    & i, r, d, L, n, c1, c2, c3, ca, rank_mpi )
    !
    !=== åνϤӥ顼ˤ뽪λ
    !
    ! åɸϤؽϤѤޤ
    !
    ! ʸѿ where ˤϥץ̾ (֥롼̾) ʤɡ
    ! ץΤɤǥåϤΤ򼨤ΤͿޤ
    !
    ! ʸѿ message ˤϡϤʸͿޤ
    ! ץѿ i, r, d, L, s, n, c1, c2, c3 ղäޤ
    ! ܺ٤˴ؤƤ dc_string#CPrintf 򻲾ȤƲ
    !
    ! ʸѿ level ϽϤåμǡ
    ! <b><tt>"W"</tt></b> (ޤ<b><tt>"Warning"</tt></b>
    ! ʤ <b><tt>"W"</tt></b> ǻϤޤʸ)
    ! Ϳ<b>ٹ</b>Ǥ뤳Ȥ
    ! <b><tt>"E"</tt></b> (ޤ<b><tt>"Error"</tt></b>
    ! ʤ <b><tt>"E"</tt></b> ǻϤޤʸ) Ϳ
    ! <b>顼 (åϸץλ) </b>Ǥ뤳Ȥ
    ! ʳʸ ( <b><tt>"M"</tt></b>
    ! Ϳ뤳ȤꤷƤޤ)
    ! Ϳ<b>̾Υå</b>Ǥ뤳Ȥꤷޤ
    ! <b><tt>"E"</tt></b>Ϳϥåϸ塢ץ
    ! λޤ顼ɤ dc_error#USR_ERRNO Ȥʤޤ
    !

    use dc_types  ,only: STRING, DP
    use dc_string ,only: UChar, StrHead, Printf, CPrintf
    use dc_error  ,only: StoreError, USR_ERRNO

    implicit none

    character(*), intent(in)          :: level ! "E", "W", "M" Τɤ줫Ϳ롣
    character(*), intent(in)          :: where ! ץ̾³̾
    character(*), intent(in)          :: message ! å
    integer     , intent(in), optional:: i(:), n(:)
    real        , intent(in), optional:: r(:)
    real(DP)    , intent(in), optional:: d(:)
    logical     , intent(in), optional:: L(:)
    character(*), intent(in), optional:: c1, c2, c3
    character(*), intent(in), optional:: ca(:)
    integer     , intent(in), optional:: rank_mpi
                                        ! MPI ѻ, ǻꤵ줿
                                        ! 󥯿ΥΡɤǤΤ
                                        ! åϤԤޤ. 
                                        ! ͤͿˤ, 
                                        ! ƤΥΡɤǽϤԤޤ. 
                                        ! 
                                        ! MPI ѤƤʤˤ
                                        ! Υץ̵뤵ޤ. 
                                        ! 
                                        ! When MPI is used, messages are 
                                        ! output in only node that has
                                        ! this runk number. 
                                        ! If negative value is given, 
                                        ! output is done on all nodes
                                        ! 
                                        ! This option is ignored 
                                        ! if MPI is not used. 
                                        ! 

    character(string)        :: msg
  continue

    if ( invalid_rank_number( rank_mpi ) ) return

    if (   StrHead(  'ERROR', trim( UChar(level) )  )   ) then
      msg = Cprintf(message, &
        &           i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3, ca=ca)
      call StoreError(USR_ERRNO, where, cause_c=msg)

    elseif (   StrHead(  'WARNING', trim( UChar(level) )  )   ) then
      msg = Cprintf(message, &
        &           i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3, ca=ca)
      msg=' *** WARNING [' // trim(where) // '] ***  '// trim(msg)
      call Printf(fmt='%c', c1=msg)

    else
      msg = Cprintf(message, &
        &           i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3, ca=ca)
      msg=' *** MESSAGE [' // trim(where) // '] ***  ' // trim(msg)
      call Printf(fmt='%c', c1=msg)

    endif

    return
  end subroutine MessageNotifyC

  subroutine MessageNotifyI(number, where, message, &
    & i, r, d, L, n, c1, c2, c3, ca, rank_mpi )
    !
    !=== åνϤӥ顼ˤ뽪λ
    !
    ! Ūˤ⤦ MessageNotify (ޤ dc_message#MessageNotifyC)
    ! ƱͤǤ裱˿ͷѿ
    ! number Ȥޤ number ϥ顼ɤȤơ
    ! Τޤ dc_error#StoreError ˰Ϥޤ
    ! 顼ɤ˴ؤƤ (dc_error 򻲾Ȥ)
    !
    use dc_types  ,only: DP
    use dc_string ,only: CPrintf
    use dc_error  ,only: StoreError, USR_ERRNO

    implicit none

    integer,      intent(in)          :: number    ! 顼 (dc_error )
    character(*), intent(in)          :: where
    character(*), intent(in), optional:: message
    integer     , intent(in), optional:: i(:), n(:)
    real        , intent(in), optional:: r(:)
    real(DP)    , intent(in), optional:: d(:)
    logical     , intent(in), optional:: L(:)
    character(*), intent(in), optional:: c1, c2, c3
    character(*), intent(in), optional:: ca(:)
    integer     , intent(in), optional:: rank_mpi
                                        ! MPI ѻ, ǻꤵ줿
                                        ! 󥯿ΥΡɤǤΤ
                                        ! åϤԤޤ. 
                                        ! ͤͿˤ, 
                                        ! ƤΥΡɤǽϤԤޤ. 
                                        ! 
                                        ! MPI ѤƤʤˤ
                                        ! Υץ̵뤵ޤ. 
                                        ! 
                                        ! When MPI is used, messages are 
                                        ! output in only node that has
                                        ! this runk number. 
                                        ! If negative value is given, 
                                        ! output is done on all nodes
                                        ! 
                                        ! This option is ignored 
                                        ! if MPI is not used. 
                                        ! 

  continue

    if ( invalid_rank_number( rank_mpi ) ) return

    if (.not. present(message)) then
      call StoreError(number, where)

    else
      call StoreError(number, where,  &
        &             cause_c=CPrintf( message, &
        &             i=i, r=r, d=d, L=L, n=n, c1=c1, c2=c2, c3=c3, ca=ca )  )
    endif

    return
  end subroutine MessageNotifyI

  subroutine MessageSuppressMPI0( rank )
    implicit none
    integer, intent(in):: rank
                                        ! ϤΡɤΥ󥯿. 
                                        ! 
                                        ! ˻ꤵ줿󥯿ʳ
                                        ! ΡɤǤνϤ޻ߤޤ. 
                                        ! 
                                        ! MPI ѤƤʤˤ
                                        ! ֥롼̵Ǥ. 
                                        ! 
                                        ! Number of rank of an node that output. 
                                        ! 
                                        ! Output on nodes that do not have 
                                        ! this rank number is suppressed. 
                                        ! 
                                        ! This subroutine is ignored, 
                                        ! if MPI is not used. 
                                        ! 
  continue
    output_rank = rank
  end subroutine MessageSuppressMPI0


  logical function invalid_rank_number( rank_mpi ) result(result)
    implicit none
    integer     , intent(in), optional:: rank_mpi
                                        ! MPI ѻ, ǻꤵ줿
                                        ! 󥯿ΥΡɤǤΤ
                                        ! åϤԤޤ. 
                                        ! ͤͿˤ, 
                                        ! ƤΥΡɤǽϤԤޤ. 
                                        ! 
                                        ! MPI ѤƤʤˤ
                                        ! Υץ̵뤵ޤ. 
                                        ! 
                                        ! When MPI is used, messages are 
                                        ! output in only node that has
                                        ! this runk number. 
                                        ! If negative value is given, 
                                        ! output is done on all nodes
                                        ! 
                                        ! This option is ignored 
                                        ! if MPI is not used. 
                                        ! 
#ifdef LIB_MPI
    logical:: initflag_mpi
    integer:: err_mpi
#endif
  continue
  
#ifndef LIB_MPI
    result = .false.
    return
#else
    if ( save_myrank < 0 ) then
      call MPI_Initialized(initflag_mpi, err_mpi)
      if ( initflag_mpi ) then
        call MPI_Comm_Rank(MPI_COMM_WORLD, save_myrank, err_mpi)
      else
        result = .false.
        return
      end if
    end if

    if ( .not. present(rank_mpi) ) then
      if ( output_rank > -1 ) then
        if ( output_rank == save_myrank ) then
          result = .false.
          return
        else
          result = .true.
          return
        end if
      end if

      result = .false.
      return
    end if

    if ( rank_mpi < 0 ) then
      result = .false.
      return
    end if

    if ( rank_mpi == save_myrank ) then
      result = .false.
    else
      result = .true.
    end if
#endif
  end function invalid_rank_number

end module dc_message
