!= ñ̤β
!= Parse units
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dccalparseunit.f90,v 1.2 2009-10-17 14:08:58 morikawa Exp $
! Tag Name::  $Name: gtool5-20101228-1 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե˵ܤ³ dc_calendar ⥸塼뤫󶡤ޤ. 
!
! Procedures described in this file are provided from "dc_calendar" module. 
!

subroutine DCCalParseUnit1( unit_str, unit_sym, err )
  !
  ! ʸѿñ *unit_str* ѿñ
  ! *unit_sym* Ѵޤ. 
  ! *unit_str* Ȥͭʸϰʲ̤Ǥ. 
  !
  ! dc_calendar_types#UNIT_SEC          :: äñ
  ! dc_calendar_types#UNIT_MIN          :: ʬñ
  ! dc_calendar_types#UNIT_HOUR         :: ֤ñ
  ! dc_calendar_types#UNIT_DAY          :: ñ
  ! dc_calendar_types#UNIT_MONTH        :: ñ
  ! dc_calendar_types#UNIT_YEAR         :: ǯñ
  ! 
  ! ͭʸͿ줿, *uni_sym* ˰ʲѿ
  ! ֤ޤ. 
  !
  ! dc_calendar_types#UNIT_SYMBOL_SEC          :: äñ
  ! dc_calendar_types#UNIT_SYMBOL_MIN          :: ʬñ
  ! dc_calendar_types#UNIT_SYMBOL_HOUR         :: ֤ñ
  ! dc_calendar_types#UNIT_SYMBOL_DAY          :: ñ
  ! dc_calendar_types#UNIT_SYMBOL_MONTH        :: ñ
  ! dc_calendar_types#UNIT_SYMBOL_YEAR         :: ǯñ
  !
  ! ̵ͤͿ줿, 顼ޤ. 
  !
  ! Parse a character variable of units of date *unit_str*, and 
  ! return an integer variable of units of date *unit_sym*. 
  ! Valid strings as *unit_str* are as follows. 
  !
  ! dc_calendar_types#UNIT_SEC          :: Units of second
  ! dc_calendar_types#UNIT_MIN          :: Units of minute
  ! dc_calendar_types#UNIT_HOUR         :: Units of hour
  ! dc_calendar_types#UNIT_DAY          :: Units of day
  ! dc_calendar_types#UNIT_MONTH        :: Units of month
  ! dc_calendar_types#UNIT_YEAR         :: Units of year
  !
  ! When a valid string is specified, an integer corresponding 
  ! one of following variables is returned to *unit_sym*. 
  !
  ! dc_calendar_types#UNIT_SYMBOL_SEC          :: Units of second
  ! dc_calendar_types#UNIT_SYMBOL_MIN          :: Units of minute
  ! dc_calendar_types#UNIT_SYMBOL_HOUR         :: Units of hour
  ! dc_calendar_types#UNIT_SYMBOL_DAY          :: Units of day
  ! dc_calendar_types#UNIT_SYMBOL_MONTH        :: Units of month
  ! dc_calendar_types#UNIT_SYMBOL_YEAR         :: Units of year
  !
  ! If an invalid string is specified an error is caused. 
  !

  use dc_calendar_types, only: UNIT_SYMBOL_ERR
  use dc_calendar_internal, only: dccaldate_str2usym
  use dc_message, only: MessageNotify
  use dc_string, only: LChar
  use dc_trace, only: BeginSub, EndSub
  use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, DC_EBADCALTYPE, DC_EBADUNIT
  use dc_types, only: STRING, DP
  implicit none
  character(*), intent(in):: unit_str
  integer, intent(out):: unit_sym
  logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 


  ! ѿ
  ! Work variables
  !
  integer:: stat
  character(STRING):: cause_c
  character(*), parameter:: subname = 'DCCalParseUnit1'
continue
  call BeginSub( subname )
  stat = DC_NOERR
  cause_c = ''

  ! ñ̤ʸ򥷥ܥ (ѿ) Ѵ
  ! Convert strings of units into symbols (integer variables)
  !
  unit_sym = dccaldate_str2usym( unit_str )

  ! 顼
  ! Error Handling
  !
  if ( unit_sym == UNIT_SYMBOL_ERR ) then
    call MessageNotify('W', subname, 'unit_str=<%c> is invalid. (ONLY day,hour,min,sec are valid)', &
      & c1 = trim(unit_str) )
    stat = DC_EBADUNIT
    goto 999
  end if

  ! λ, 㳰
  ! Termination and Exception handling
  !
999 continue
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )
end subroutine DCCalParseUnit1
