!= ǯɤȽ
!= Judge whether it is a leap year
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dccaldatechkleapyear.f90,v 1.1 2009-12-29 08:16:49 morikawa Exp $
! Tag Name::  $Name: gtool5-20100924 $
! Copyright:: Copyright (C) GFD Dennou Club, 2009-. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! Υե˵ܤ³ dc_calendar ⥸塼뤫󶡤ޤ. 
!
! Procedures described in this file are provided from "dc_calendar" module. 
!
function DCCalDateChkLeapYear1( elapse_sec, date, cal ) result(result)
  ! ǯɤȽ. 
  !
  ! άǽ *date* ά줿ˤ, dc_calendar 
  ! ݻȤѤޤ. 
  ! *date* άʤˤϤѿꤵ줿
  ! ȤѤޤ. 
  !
  ! άǽ *cal* ά줿ˤ, вÿ *elapse_sec* 
  ! ǯʬؤѴ dc_calendar ݻѤޤ. 
  ! *cal* άʤˤϤѿꤵ줿Ѥޤ. 
  !
  ! Judge whether it is a leap year. 
  !
  ! If an optional argument *date* is omitted, 
  ! information of date that is stored in the "dc_calendar" 
  ! is used as date of origin, 
  ! If *date* is not omitted, information of the variable is used as 
  ! date of origin. 
  !
  ! If an optional argument *cal* is omitted, 
  ! information of calendar that is stored in the "dc_calendar" 
  ! is used for conversion of elapsed seconds *elapse_sec* into 
  ! year-month-day etc.
  ! If *cal* is not omitted, information of the variable is used. 
  !
  use dc_calendar_types, only: DC_CAL_DATE, DC_CAL, &
    & CAL_USER_DEFINED, &
    & CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN, CAL_360DAY
  use dc_calendar_internal, only: default_cal, default_cal_set, default_date, &
    & dccaldate_normalize, dccaldate_ym2d
  use dc_calendar_generic, only: DCCalDateInquire
  use dc_types, only: DP
  implicit none
  logical:: result
                              ! ǯǤ .true., Ǥʤ .false.
                              !
                              ! Leap year: .true., No leap year: .false.
  real(DP), intent(in):: elapse_sec
                              ! *date* ηвÿ. 
                              ! Elapsed seconds from *date*. 
  type(DC_CAL_DATE), intent(in), optional, target:: date
                              ! Ȥʤ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! date of origin. 
  type(DC_CAL), intent(in), optional, target:: cal
                              ! ᤿֥. 
                              ! 
                              ! An object that stores information of 
                              ! calendar. 
  ! ѿ
  ! Work variables
  !
  type(DC_CAL_DATE), pointer:: datep =>null()
  type(DC_CAL), pointer:: calp =>null()
  integer:: year, month, day, hour, min
  real(DP):: sec
continue

  ! ֥ȤΥݥ󥿳
  ! Associate pointer of an object
  !
  if ( present( date ) ) then
    datep => date
  else
    datep => default_date
  end if

  if ( present( cal ) ) then
    calp => cal
  else
    calp => default_cal
    if ( .not. calp % initialized ) call default_cal_set
  end if

  ! Υå
  ! Check initialization
  !
  result = .false.
  if ( .not. datep % initialized ) return
  if ( .not. calp % initialized ) return

  ! в֤Ϳ
  ! Inquire date and time when elapse time is given
  !
  call DCCalDateInquire( year, month, day, hour, min, sec, & ! (out)
    & elapse_sec = elapse_sec, date = date , cal = cal )   ! (in)

  ! ǯȽ
  ! Judge leap year
  !
  select case( calp % cal_type )
  case( CAL_JULIAN )
    if ( mod( year, 4 ) == 0 ) then
      result = .true.
    else
      result = .false.
    end if

  case( CAL_GREGORIAN )
    if ( mod( year, 400 ) == 0 ) then
      result = .true.
    elseif ( mod( year, 100 ) == 0 ) then
      result = .false.
    elseif ( mod( year, 4 ) == 0 ) then
      result = .true.
    else
      result = .false.
    end if

  case default
    result = .false.
  end select

end function DCCalDateChkLeapYear1
