!= ѿνϾκ
!= Delete output information of a variable
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: hstnmlinfodelete.f90,v 1.1 2009-05-11 15:15:15 morikawa Exp $
! Tag Name::  $Name: gtool5-20090704 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
  recursive subroutine HstNmlInfoDelete( gthstnml, &
    & name, &
    & err )
    !
    ! ѿνϾޤ. 
    !
    ! ʤ, Ϳ줿 *gthstnml*  HstNmlInfoCreate ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ. 
    !
    ! Delete output information of a variable.
    ! 
    ! If *gthstnml* is not initialized by "HstNmlInfoCreate" yet, 
    ! error is occurred.
    !
    use gtool_history_nmlinfo_types, only: GTHST_NMLINFO, GTHST_NMLINFO_ENTRY
    use gtool_history_nmlinfo_internal, only: ListSearch
    use gtool_history_nmlinfo_internal, only: name_delimiter
    use dc_trace, only: BeginSub, EndSub, DbgMessage
    use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT, DC_EARGLACK, USR_ERRNO, HST_ENOTINDEFINE
    implicit none
    type(GTHST_NMLINFO), intent(inout):: gthstnml
    character(*), intent(in):: name
                              ! ѿ̾. 
                              ! 
                              ! Ƭζ̵뤵ޤ. 
                              ! 
                              ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                              ! ѿꤹ뤳ȤǽǤ. 
                              ! 
                              ! Variable identifier. 
                              ! 
                              ! Blanks at the head of the name are ignored. 
                              ! 
                              ! Multiple variables can be specified 
                              ! as "Data1,Data2". Delimiter is comma. 
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰. 
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ. 
                              !  *err* Ϳ, 
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ. 
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr =>null()
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr_prev =>null()
    type(GTHST_NMLINFO_ENTRY), pointer:: hptr_next =>null()
    character(TOKEN), pointer:: varnames_array(:) =>null()
    integer:: i, vnmax
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'HstNmlInfoDelete'
  continue
    call BeginSub( subname, &
      & fmt = '@name=%c', &
      & c1 = trim( name ) )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. gthstnml % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'GTHST_NMLINFO'
      goto 999
    end if

    if ( .not. gthstnml % define_mode ) then
      stat = HST_ENOTINDEFINE
      cause_c = 'Delete'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  ʣѿ
    !  Delete multiple variables
    !-----------------------------------------------------------------
    if ( present_and_not_empty(name) ) then
      if ( index(name, name_delimiter) > 0 ) then
        call DbgMessage( 'multiple entries (%c) will be deleted', c1 = trim(name) )
        call Split( str = name, sep = name_delimiter, & ! (in)
          & carray = varnames_array )                   ! (out)
        vnmax = size( varnames_array )

        do i = 1, vnmax
          call HstNmlInfoDelete( &
            & gthstnml = gthstnml, &      ! (inout)
            & name = varnames_array(i), & ! (in)
            & err = err )                 ! (out)
          if ( present_and_true( err ) ) then
            deallocate( varnames_array )
            stat = USR_ERRNO
            goto 999
          end if
        end do
        deallocate( varnames_array )
        goto 999
      end if
    end if

    !-----------------------------------------------------------------
    !  *gthstnml* ξ.
    !  Delete information in *gthstnml*
    !-----------------------------------------------------------------
    hptr => gthstnml % gthstnml_list
    call ListSearch( gthstnml_list = hptr, & ! (inout)
      &              name = name, &          ! (in)
      &              previous = hptr_prev, & ! (out)
      &              next = hptr_next )      ! (out)

    if ( .not. associated( hptr ) ) goto 999
    if ( ( trim(hptr % name) /= '' ) .and. associated( hptr_prev ) ) then
      call DbgMessage( 'entry (%c) is deleted', c1 = trim( adjustl( name ) ) )
      hptr_prev % next => hptr_next
      deallocate( hptr )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine HstNmlInfoDelete
