!= netCDF ѿΥץ
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: gdncvaropen.f90,v 1.2 2009-05-25 09:51:59 morikawa Exp $
! Tag Name::  $Name: gtool5-20090602 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2006. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! ʲΥ֥롼, ؿ gtdata_netcdf_generic 󶡤ޤ
!

recursive subroutine GDNcVarOpen(var, url, writable, err)
  use dc_types, only: STRING
  use gtdata_netcdf_types, only: GD_NC_VARIABLE, GD_NC_VARIABLE_SEARCH
  use gtdata_netcdf_internal, only: vtable_add
  use gtdata_netcdf_file_generic, only: GDNcFileOpen
  use dc_url, only: UrlSplit
  use dc_error, only: StoreError
  use dc_trace, only: BeginSub, EndSub
  use netcdf_f77, only: NF_NOERR, NF_MAX_NAME, NF_ENOTVAR, NF_EBADDIM, &
    & nf_inq_varid, nf_inq_nvars, nf_inq_varname, nf_inq_dimid
  implicit none
  type(GD_NC_VARIABLE), intent(out):: var
  character(len = *), intent(in):: url
  logical, intent(in), optional:: writable
  logical, intent(out), optional:: err
  character(len = STRING):: filename, varname
  character(len = NF_MAX_NAME):: dimname
  integer:: stat, nvars, i
  type(GD_NC_VARIABLE_SEARCH):: e
  character(len = *), parameter:: subname = 'GDNcVarOpen'
continue
  call BeginSub(subname)
  call UrlSplit(url, file=filename, var=varname)
  if (filename == "") filename = "gtool.nc"
  call GDNcFileOpen(e%fileid, trim(filename), stat=stat, writable=writable, err=err )
  if (stat /= 0) goto 999
  !
  ! ̾ѿõФ
  !
  if (varname /= '') then
    e%varid = 0
    stat = nf_inq_varid(e%fileid, trim(varname), e%varid)
    if (stat == NF_ENOTVAR) then
      e%varid = 0
      stat = NF_NOERR
    endif
  else
    ! ̾ʤǤмѿǤʤǽѿȤ
    stat = nf_inq_nvars(e%fileid, nvars)
    if (stat /= 0) goto 999
    e%varid = 1
    do, i = 1, nvars
      stat = nf_inq_varname(e%fileid, i, dimname)
      if (stat /= NF_NOERR) goto 999
      stat = nf_inq_dimid(e%fileid, dimname, e%dimid)
      if (stat == NF_NOERR) cycle
      if (stat /= NF_EBADDIM) goto 999
      e%varid = i
      stat = NF_NOERR
      exit
    enddo
  endif
  if (stat /= NF_NOERR) goto 999
  !
  ! id Ĵ٤
  !
  stat = nf_inq_dimid(e%fileid, trim(varname), e%dimid)
  if (stat /= NF_NOERR) then
    if (e%varid <= 0) goto 999
    e%dimid = 0
  endif
  !
  stat = vtable_add(var, e)
  if (stat /= NF_NOERR) goto 999
  call EndSub(subname, 'an=%d file=%d var=%d', i=(/var%id, e%fileid, e%varid/))
  call StoreError(stat, subname, err)
  return
  !
  ! 顼 (ﴰλƤ)
  !
999 continue
  var = GD_NC_VARIABLE(-1)
  call EndSub(subname, 'an=%d err', i=(/var%id/))
  call StoreError(stat, subname, err, cause_c=url)
end subroutine GDNcVarOpen
