!== dc_date.f90 - դӻ˴ؤ³󶡤⥸塼
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dc_date.f90,v 1.11 2009-01-14 10:30:59 morikawa Exp $
! Tag Name::  $Name: gtool5-20090211 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module dc_date
  !== Overview
  !
  ! դӻ򰷤μ³󶡤ޤ
  !
  !== Procedures List
  !
  ! ʲμ³Ϲ¤ dc_date_types#DC_DATETIME ޤ
  ! dc_date_types#DC_DIFFTIME ѿ (, ˴ؤǼ)
  ! оݤȤޤ.
  !
  ! DCDateTimeCreate     :: dc_date_types#DC_DATETIME ѿν
  ! DCDiffTimeCreate     :: dc_date_types#DC_DIFFTIME ѿν
  !
  ! #assignment(=)       :: dc_date_types#DC_DATETIME ѿ
  !                         dc_date_types#DC_DIFFTIME ѿν
  !
  ! Eval                 :: , ̤˼
  !
  ! toChar               :: , ʸѿѴ
  !
  ! EvalDay     ::  (¿) ˴Ƽ
  ! EvalHour    ::  (¿) ˴Ƽ
  ! EvalMin     :: ʬ (¿) ˴Ƽ
  ! EvalSec     ::  (¿) ˴Ƽ
  ! EvalNondim  :: ̵ (¿) ˴Ƽ
  ! EvalByUnit  :: ñ̤ꤷ, , , ʬ, äΤŤ줫 (¿) 
  !                ˴Ƽ
  !
  ! #operator(+)  :: û (dc_date_types#DC_DATETIME  
  !                  dc_date_types#DC_DIFFTIME  Ʊ)
  ! #operator(-)  ::  (dc_date_types#DC_DATETIME  
  !                  dc_date_types#DC_DIFFTIME  Ʊ)
  ! #operator(*)  :: 軻 (dc_date_types#DC_DIFFTIME ȿͷ)
  ! #operator(/)  ::  (dc_date_types#DC_DIFFTIME ȿͷ)
  ! mod           :: ; (dc_date_types#DC_DIFFTIME Ʊ)
  ! #operator(==) ::  (dc_date_types#DC_DATETIME Ʊ)
  ! #operator(>)  ::  (dc_date_types#DC_DATETIME Ʊ)
  ! #operator(<)  ::  (dc_date_types#DC_DATETIME Ʊ)
  ! max           :: 礭֤ͤ
  ! min           :: ֤ͤ
  !
  ! SetZone       :: ॾѹ
  !
  ! DCDateTimePutLine    :: dc_date_types#DC_DATETIME ѿ˳ǼƤ
  !                         , ΰ
  ! DCDiffTimePutLine    :: dc_date_types#DC_DIFFTIME ѿ˳ǼƤ
  !                         , ΰ
  !
  !
  ! ʲμ³ dc_date_types ѿѹޤ.
  !
  ! SetCaltype  :: ˡΥǥեȤѹ
  ! SetSecOfDay :: 1 ÿΥǥեȤѹ
  !
  ! ¾μ³
  !
  ! ValidCaltype   :: ˡͭʤΤå
  ! ValidZone      :: ॾȤͭå
  ! ZoneToDiff     :: ॾ dc_date_types#DC_DIFFTIME ѿؤѴ
  ! ParseTimeUnits :: ֤ñ̤Ϥ, ñ̤Υܥ֤ޤ. 
  !
  !== Usage
  !
  !=== ߻ɽ
  !
  ! DC_DATETIME ѿ˥֥롼 DCDateTimeCreate 
  ! Ѥ, 郎ꤵޤ.
  ! Τ褦äǯꤷʤȸ߻郎ꤵޤ.
  ! ꤵ줿 toChar ˤäʸѿؤѴǤޤ.
  ! ֥롼 Printf ˴ؤƤ dc_string#Printf 򻲾Ȥ.
  !
  !     program dc_date_sapmle1
  !       use dc_string, only: Printf
  !       use dc_date_types, only: DC_DATETIME
  !       use dc_date, only: DCDateTimeCreate, toChar
  !       implicit none
  !       type(DC_DATETIME) :: time
  !
  !       call DCDateTimeCreate( time = time ) ! (out)
  !       call Printf( fmt = 'current date and time is %c', c1 = trim( toChar(time) ) )
  !     end program dc_date_sapmle1
  !
  !=== , βû
  !
  ! DC_DIFFTIME ѿɽޤ. Ǥ,
  ! ɽ뤿ѿȤ *diff*
  ! Ѱդ, ֥롼 Create ˤä 25  + 12  + 50 ʬ
  ! ꤷƤޤ. DC_DATETIME ѿ *time_before*  *diff* Ȥ
  ! #operator(+) ˤäƲû뤳Ȥ *time_before* 
  ! 25  + 12  + 50 ʬʤ᤿ *time_after* Ƥޤ.
  !
  !     program dc_date_sapmle2
  !       use dc_types, only: DP
  !       use dc_string, only: Printf
  !       use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
  !       use dc_date, only: DCDateTimeCreate, DCDiffTimeCreate, toChar, operator(+)
  !       implicit none
  !       type(DC_DATETIME) :: time_before, time_after
  !       type(DC_DIFFTIME) :: diff
  !
  !       call DCDateTimeCreate( time = time_before, & ! (out)
  !         & year = 2006, mon = 6,  day = 10, &       ! (in)
  !         & hour = 14,   min = 15, sec = 0.0_DP )    ! (in)
  !       call DCDiffTimeCreate( diff = diff, &        ! (out)
  !         & day = 25, hour = 12, min = 50)           ! (in)
  !
  !       time_after = time_before + diff
  !
  !       call Printf( fmt = '%c + %c = %c', &
  !         & c1 = trim( toChar(time_before) ), c2 = trim( toChar(diff) ), &
  !         & c3 = trim( toChar(time_after) ) )
  !     end program dc_date_sapmle2
  !
  !
  !=== ʬΥ롼פؤα
  !
  ! ʲ dA/dt = - A ( 1, =0.0001)  t = 12 ()
  ! ޤǲ򤯥ץǤ. ʬˤʺʬѤƤޤ.
  ! t, ǡνϴֳ, ׻֤ DC_DIFFTIME Ѥ뤳Ȥ,
  ! 롼פνλ
  ! ǡϤκݤλӤưפȤʤޤ.
  !
  !     program dc_date_sapmle3
  !       use dc_types, only: DP
  !       use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit, mod, &
  !         & operator(*), operator(==), operator(>)
  !       use dc_date_types, only: DC_DIFFTIME
  !       implicit none
  !       real(DP)                :: func_a = 1.0d0    ! ؿ A ν
  !       real(DP), parameter     :: alph   = 0.0001d0 !  
  !       character(*), parameter :: out_unit = 'hour' ! Ϥñ
  !       type(DC_DIFFTIME):: DelTimef, intervalf, calctimef
  !       integer :: i
  !     continue
  !       call DCDiffTimeCreate( &            !       t = 5.0 ()
  !         & diff = DelTimef, &              ! (out)
  !         & value = 5.0_DP, unit = 'sec')   ! (in)
  !       call DCDiffTimeCreate( &            !       ǡϴֳ = 1.0 (ʬ)
  !         & diff = intervalf, &             ! (out)
  !         & value = 1.0_DP, unit = 'min')   ! (in)
  !       call DCDiffTimeCreate( &            !       ׻ = 12.0 ()
  !         & diff = calctimef, &             ! (out)
  !         & value = 12.0_DP, unit = 'hour') ! (in)
  !     
  !       open( 10, file='dc_date_sample.dat' )
  !       write(10,'(A,A,A)') '#  ', out_unit, '                value'
  !     
  !       i = 1
  !       do
  !         if (DelTimef * i > calctimef) exit    ! ׻֤᤮齪λ
  !     
  !         !---------------------------------------------
  !         ! A_(n+1) = (1 - t) * A_(n)
  !         !---------------------------------------------
  !         func_a = (1.0 - alph * EvalSec(DelTimef)) * func_a
  !     
  !         !---------------------------------------------
  !         ! intervalf (1 ʬ) ˥ǡ
  !         !---------------------------------------------
  !         if (mod(DelTimef * i, intervalf) == 0) then
  !           write(10,*) ' ', EvalByUnit( DelTimef * i, out_unit ), func_a
  !         end if
  !         i = i + 1
  !       end do
  !     end program dc_date_sapmle3
  !
  !


  ! ջȻֳִ֤̤롣
  ! ˤäƼޤ륵֥롼 dc_date_types ֤

  use dc_date_types, only: DC_DATETIME, DC_DIFFTIME
  use dc_types, only: DP, STRING, TOKEN
  use dc_present, only: present_and_not_empty

  implicit none

  private
  public:: DCDateTimeCreate, DCDiffTimeCreate
  public:: DCDateTimePutLine, DCDiffTimePutLine
  public:: Eval
  public:: SetCaltype, SetZone, SetSecOfDay
  public:: ValidCaltype, ValidZone, ZoneToDiff, ParseTimeUnits

  public:: assignment(=)
  public:: mod, operator(/), operator(-), operator(+), operator(*)
  public:: operator(<), operator(>), operator(>=), operator(<=)
  public:: operator(==), max, min
  public:: toChar, toCharCal
  public:: EvalDay, EvalHour, EvalMin, EvalSec, EvalNondim, EvalByUnit
  public:: dcdate_normalize, dcdate_parse_unit, dcdate_set_day_seconds_scl

  !-----------------------------------------------
  ! ߴ
  ! For backward compatibility
  public:: Create, PutLine

  interface DCDateTimeCreate
    subroutine DCDateTimeCreate1(time, &
      & year, mon, day, hour, min, sec, &
      & zone, zone_hour, zone_min, caltype, caltype_str, day_seconds, &
      & sclyear, sclmon, sclday, sclsec, err) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_DATETIME), intent(out):: time
      integer, intent(in), optional:: year, mon, day, hour, min
      real(DP),intent(in), optional:: sec, day_seconds
      character(*), intent(in), optional :: zone
      integer, intent(in), optional :: zone_hour
      integer, intent(in), optional :: zone_min
      integer, intent(in), optional:: caltype
      character(*), intent(in), optional:: caltype_str
      type(DC_SCALED_SEC), intent(in), optional:: sclyear, sclmon, sclday, sclsec
      logical, intent(out), optional:: err
    end subroutine DCDateTimeCreate1
  end interface

  interface DCDiffTimeCreate
    subroutine DCDiffTimeCreate1(diff, &
      & year, mon, day, hour, min, sec, day_seconds, nondim, &
      & sclyear, sclmon, sclday, sclsec ) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_DIFFTIME), intent(out) :: diff
      integer, intent(in), optional:: year, mon, day, hour, min
      real(DP),intent(in), optional:: sec, day_seconds, nondim
      type(DC_SCALED_SEC), intent(in), optional:: sclyear, sclmon, sclday, sclsec
    end subroutine DCDiffTimeCreate1

    subroutine DCDiffTimeCreate2D(diff, value, unit, unit_symbol, err) !:doc-priority 70:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out) :: diff
      real(DP), intent(in) :: value
      character(*), intent(in) :: unit
      integer, intent(in), optional :: unit_symbol
      logical, intent(out), optional :: err
    end subroutine DCDiffTimeCreate2D

    subroutine DCDiffTimeCreate2R(diff, value, unit, unit_symbol, err) !:doc-priority 80:
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out) :: diff
      real, intent(in) :: value
      character(*), intent(in) :: unit
      integer, intent(in), optional :: unit_symbol
      logical, intent(out), optional :: err
    end subroutine DCDiffTimeCreate2R

    subroutine DCDiffTimeCreate2I(diff, value, unit, unit_symbol, err) !:doc-priority 90:
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out) :: diff
      integer, intent(in) :: value
      character(*), intent(in) :: unit
      integer, intent(in), optional :: unit_symbol
      logical, intent(out), optional :: err
    end subroutine DCDiffTimeCreate2I

  end interface

  interface DCDateTimePutLine
    subroutine DCDateTimePutLine(time, unit, indent)
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(in) :: time
      integer, intent(in), optional :: unit
      character(*), intent(in), optional:: indent
    end subroutine DCDateTimePutLine
  end interface

  interface DCDiffTimePutLine
    subroutine DCDiffTimePutLine(diff, unit, indent)
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(in) :: diff
      integer, intent(in), optional :: unit
      character(*), intent(in), optional:: indent
    end subroutine DCDiffTimePutLine
  end interface

  interface assignment(=)

    subroutine DCDateTimeCreateI(time, sec) !:doc-priority 20:
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(out):: time
      integer, intent(in):: sec
    end subroutine DCDateTimeCreateI

    subroutine DCDateTimeCreateR(time, sec) !:doc-priority 30:
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(out):: time
      real, intent(in):: sec
    end subroutine DCDateTimeCreateR

    subroutine DCDateTimeCreateD(time, sec) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(out):: time
      real(DP), intent(in):: sec
    end subroutine DCDateTimeCreateD

    subroutine DCDiffTimeCreateI(diff, sec) !:doc-priority 60:
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out):: diff
      integer, intent(in):: sec
    end subroutine DCDiffTimeCreateI

    subroutine DCDiffTimeCreateR(diff, sec) !:doc-priority 70:
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out):: diff
      real, intent(in):: sec
    end subroutine DCDiffTimeCreateR

    subroutine DCDiffTimeCreateD(diff, sec) !:doc-priority 80:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out):: diff
      real(DP), intent(in):: sec
    end subroutine DCDiffTimeCreateD

!!$    subroutine DCDateLetFC(diff, string)
!!$      use dc_date_types, only: DC_DIFFTIME
!!$      type(DC_DIFFTIME), intent(out):: diff
!!$      character(len = *), intent(in):: string
!!$    end subroutine DCDateLetFC
!!$
!!$    subroutine DCDateLetTC(time, string)
!!$      use dc_date_types, only: DC_DATETIME
!!$      type(DC_DATETIME), intent(out):: time
!!$      character(len = *), intent(in):: string
!!$    end subroutine DCDateLetTC

  end interface

  interface SetCaltype
    subroutine DCDateTimeSetCaltype(caltype)
      integer, intent(in):: caltype
    end subroutine DCDateTimeSetCaltype
  end interface

  interface SetSecOfDay
    subroutine DCDateTimeSetSecOfDay(sec)
      use dc_types, only: DP
      real(DP), intent(in):: sec
    end subroutine DCDateTimeSetSecOfDay
  end interface

  interface ValidCaltype
    function DCDateTimeValidCaltype(caltype) result(result)
      integer, intent(in):: caltype
      logical:: result
    end function DCDateTimeValidCaltype
  end interface

  interface ValidZone
    function DCDateTimeValidZone(zone) result(result)
      character(*), intent(in):: zone
      logical:: result
    end function DCDateTimeValidZone
  end interface

  interface ZoneToDiff
    function DCDateTimeZoneToDiff(zone) result(diff)
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME):: diff
      character(*), intent(in):: zone
    end function DCDateTimeZoneToDiff
  end interface

  interface SetZone
    subroutine DCDateTimeSetZone(time, zone, err)
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(inout):: time
      character(*), intent(in):: zone
      logical, intent(out), optional:: err
    end subroutine DCDateTimeSetZone
  end interface


  interface Eval

    subroutine DCDateTimeEval1(time, year, mon, day, hour, min, &
      & sec, caltype, zone, sclyear, sclmon, sclday, sclsec)  !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_DATETIME), intent(in):: time
      integer, intent(out), optional:: year, mon, day, hour, min, caltype
      real(DP), intent(out), optional:: sec
      character(*), intent(out), optional:: zone
      type(DC_SCALED_SEC), intent(out), optional:: sclyear, sclmon, sclday, sclsec
    end subroutine DCDateTimeEval1

!!$    subroutine DCDateTimeEval0(time, mon, day, sec)
!!$      use dc_date_types, only: DC_DATETIME
!!$      use dc_types,      only: DP
!!$      type(DC_DATETIME), intent(in):: time
!!$      integer, intent(out):: mon, day
!!$      real(DP), intent(out):: sec
!!$    end subroutine DCDateTimeEval0

    subroutine DCDiffTimeEval1(diff, &
      & year, mon, day, hour, min, sec, nondim, &
      & sclyear, sclmon, sclday, sclsec, sclnondim, err)  !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_DIFFTIME), intent(in):: diff
      integer, intent(out), optional:: year, mon, day, hour, min
      real(DP), intent(out), optional:: sec, nondim
      type(DC_SCALED_SEC), intent(out), optional:: sclyear, sclmon, sclday, sclsec, sclnondim
      logical, intent(out), optional :: err
    end subroutine DCDiffTimeEval1

  end interface

  interface EvalDay
    function DCDateTimeEvalDay(time) result(result)  !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalDay

    function DCDiffTimeEvalDay(diff) result(result)  !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDiffTimeEvalDay
  end interface

  interface EvalHour
    function DCDateTimeEvalHour(time) result(result) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalHour

    function DCDifftimeEvalHour(diff) result(result) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDifftimeEvalHour
  end interface

  interface EvalMin
    function DCDateTimeEvalMin(time) result(result) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalMin

    function DCDifftimeEvalMin(diff) result(result) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDifftimeEvalMin
  end interface

  interface EvalSec
    function DCDateTimeEvalSec(time) result(result) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalSec

    function DCDifftimeEvalSec(diff) result(result) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDifftimeEvalSec
  end interface

  interface EvalNondim
    function DCDiffTimeEvalNondim(diff) result(result)
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDiffTimeEvalNondim
  end interface

  interface EvalSclSec
    function DCDateTimeEvalSclSec(time) result(result) !:doc-priority 40:
      use dc_date_types, only: DC_DATETIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_SCALED_SEC):: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeEvalSclSec

    function DCDifftimeEvalSclSec(diff) result(result) !:doc-priority 60:
      use dc_date_types, only: DC_DIFFTIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_SCALED_SEC):: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDifftimeEvalSclSec
  end interface

  interface EvalByUnit

    function DCDateTimeEvalByUnit(time, unit, unit_symbol) result(result)
      use dc_types, only: DP, TOKEN
      use dc_date_types, only: DC_DATETIME
      real(DP):: result
      type(DC_DATETIME), intent(in):: time
      character(*), intent(in), optional:: unit
      integer, intent(in), optional:: unit_symbol
    end function DCDateTimeEvalByUnit

    function DCDiffTimeEvalByUnit(diff, unit, unit_symbol) result(result)
      use dc_types, only: DP, TOKEN
      use dc_date_types, only: DC_DIFFTIME
      real(DP):: result
      type(DC_DIFFTIME), intent(in):: diff
      character(*), intent(in), optional:: unit
      integer, intent(in), optional:: unit_symbol
    end function DCDiffTimeEvalByUnit
  end interface



  interface toChar
    function DCDateTimeToChar(time) result(result) !:doc-priority 40:
      use dc_types, only: STRING
      use dc_date_types, only: DC_DATETIME
      character(STRING) :: result
      type(DC_DATETIME), intent(in):: time
    end function DCDateTimeToChar

    function DCDiffTimeToChar(diff) result(result) !:doc-priority 60:
      use dc_types, only: STRING
      use dc_date_types, only: DC_DIFFTIME
      character(STRING) :: result
      type(DC_DIFFTIME), intent(in):: diff
    end function DCDiffTimeToChar
  end interface

  interface toCharCal
    function DCDateTimeToCharCal(time, upcase) result(result)
      use dc_types, only: TOKEN
      use dc_date_types, only: DC_DATETIME
      character(TOKEN) :: result
      type(DC_DATETIME), intent(in):: time
      logical, intent(in), optional:: upcase
    end function DCDateTimeToCharCal
  end interface

  interface operator(+)
    module procedure dcdate_add_ft
    module procedure dcdate_add_tf
    module procedure dcdate_add_ff
    module procedure dcdate_add_fr
    module procedure dcdate_add_fd
    module procedure dcdate_add_fi
  end interface

  interface operator(-)
    module procedure dcdate_sub_tf !:doc-priority 40:
    module procedure dcdate_sub_tt
    module procedure dcdate_sub_ff
    module procedure dcdate_sub_fr
    module procedure dcdate_sub_fd
    module procedure dcdate_sub_fi
  end interface

  interface operator(*)
    module procedure dcdate_mul_if !:doc-priority 51:
    module procedure dcdate_mul_fi !:doc-priority 52:
    module procedure dcdate_mul_rf !:doc-priority 61:
    module procedure dcdate_mul_fr !:doc-priority 62:
    module procedure dcdate_mul_df !:doc-priority 71:
    module procedure dcdate_mul_fd !:doc-priority 72:
  end interface

  interface operator(/)
    module procedure dcdate_div_fi
    module procedure dcdate_div_fr
    module procedure dcdate_div_fd
    module procedure dcdate_div_ff
  end interface

  interface mod
    module procedure dcdate_mod_ff
  end interface

  interface operator(==)
    module procedure dcdate_eq_tt !:doc-priority 30:
    module procedure dcdate_eq_ff !:doc-priority 40:
    module procedure dcdate_eq_if !:doc-priority 51:
    module procedure dcdate_eq_fi !:doc-priority 52:
    module procedure dcdate_eq_rf !:doc-priority 61:
    module procedure dcdate_eq_fr !:doc-priority 62:
    module procedure dcdate_eq_df !:doc-priority 71:
    module procedure dcdate_eq_fd !:doc-priority 72:
  end interface

  interface operator(>)
    module procedure dcdate_gt_tt !:doc-priority 30:
    module procedure dcdate_gt_ff !:doc-priority 40:
    module procedure dcdate_gt_fi !:doc-priority 42:
    module procedure dcdate_gt_if !:doc-priority 44:
  end interface

  interface operator(<)
    module procedure dcdate_lt_tt !:doc-priority 30:
    module procedure dcdate_lt_ff !:doc-priority 40:
    module procedure dcdate_lt_fi !:doc-priority 42:
    module procedure dcdate_lt_if !:doc-priority 44:
  end interface

  interface operator(>=)
    module procedure dcdate_ge_tt !:doc-priority 30:
    module procedure dcdate_ge_ff !:doc-priority 40:
    module procedure dcdate_ge_fi !:doc-priority 42:
    module procedure dcdate_ge_if !:doc-priority 44:
  end interface

  interface operator(<=)
    module procedure dcdate_le_tt !:doc-priority 30:
    module procedure dcdate_le_ff !:doc-priority 40:
    module procedure dcdate_le_fi !:doc-priority 42:
    module procedure dcdate_le_if !:doc-priority 44:
  end interface

  interface max
    module procedure dcdate_max_tt !:doc-priority 30:
    module procedure dcdate_max_ff !:doc-priority 40:
  end interface

  interface min
    module procedure dcdate_min_tt !:doc-priority 30:
    module procedure dcdate_min_ff !:doc-priority 40:
  end interface

  !-----------------------------------------------
  ! ߴ
  ! For backward compatibility
  interface Create
    subroutine DCDateTimeCreate1_bc(time, &
      & year, mon, day, hour, min, sec, &
      & zone, caltype, day_seconds, err) !:doc-priority 40:
      use dc_types, only: DP
      use dc_date_types, only: DC_DATETIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_DATETIME), intent(out):: time
      integer, intent(in), optional:: year, mon, day, hour, min
      real(DP),intent(in), optional:: sec, day_seconds
      character(*), intent(in), optional :: zone
      integer, intent(in), optional:: caltype
      logical, intent(out), optional:: err
    end subroutine DCDateTimeCreate1_bc

    subroutine DCDiffTimeCreate1_bc(diff, &
      & year, mon, day, hour, min, sec, day_seconds ) !:doc-priority 60:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      use dc_scaledsec, only: DC_SCALED_SEC
      type(DC_DIFFTIME), intent(out) :: diff
      integer, intent(in), optional:: year, mon, day, hour, min
      real(DP),intent(in), optional:: sec, day_seconds
    end subroutine DCDiffTimeCreate1_bc

    subroutine DCDiffTimeCreate2_bc(diff, value, unit, unit_symbol, err) !:doc-priority 70:
      use dc_types, only: DP
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(out) :: diff
      real(DP), intent(in) :: value
      character(*), intent(in) :: unit
      integer, intent(in), optional :: unit_symbol
      logical, intent(out), optional :: err
    end subroutine DCDiffTimeCreate2_bc
  end interface

  interface PutLine
    subroutine DCDateTimePutLine_bc(time, unit)
      use dc_date_types, only: DC_DATETIME
      type(DC_DATETIME), intent(in) :: time
      integer, intent(in), optional :: unit
    end subroutine DCDateTimePutLine_bc

    subroutine DCDiffTimePutLine_bc(diff, unit)
      use dc_date_types, only: DC_DIFFTIME
      type(DC_DIFFTIME), intent(in) :: diff
      integer, intent(in), optional :: unit
    end subroutine DCDiffTimePutLine_bc
  end interface

contains

  subroutine dcdate_normalize(day, sec, day_seconds, nondim_flag)
    !
    !=== ä
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    !  *day* ÿ *sec* Ԥޤ. *sec*  *day_seconds*
    ! (ά dc_date_types#day_seconds) Ķ, *day*
    ! ˷夲Ԥޤ.
    ! ޤ, *sec*  *day* 椬դξ, Ʊˤʤ褦
    ! ꤷޤ.
    !
    use dc_date_types, only: &
      & flag_set_day_seconds_scl, day_seconds_scl
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_SCALED_SEC), intent(inout):: day
    type(DC_SCALED_SEC), intent(inout):: sec
    type(DC_SCALED_SEC), intent(in), optional:: day_seconds
    logical, intent(in):: nondim_flag
    type(DC_SCALED_SEC):: sgn, day_sec, zero_sec
  continue
    if ( nondim_flag ) return
    if (present(day_seconds)) then
      day_sec = day_seconds
    else
      if ( .not. flag_set_day_seconds_scl ) call dcdate_set_day_seconds_scl
      day_sec = day_seconds_scl
    end if
    if (abs(sec) >= day_sec) then
      day = day + int(sec / day_sec)
      sec = modulo(sec, day_sec)
    end if
!!    zero_sec = 0  (ǥե = 0 Ѥ). 
    if (      ( sec > zero_sec .and. day < zero_sec ) &
      &  .or. ( sec < zero_sec .and. day > zero_sec )   ) then
      sgn = sign(day, 1)
      day = day - sgn
      sec = sec + sgn * day_sec
    endif
  end subroutine dcdate_normalize

  subroutine dcdate_set_day_seconds_scl
    use dc_scaledsec, only: DC_SCALED_SEC, assignment(=)
    use dc_date_types, only: day_seconds,  &
      & flag_set_day_seconds_scl, day_seconds_scl
  continue
    if ( .not. flag_set_day_seconds_scl ) then
      flag_set_day_seconds_scl = .true.
      day_seconds_scl = day_seconds
    end if
  end subroutine dcdate_set_day_seconds_scl

  subroutine dcdate_nondimcheck(opr, diff1, diff2, rslt)
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    ! diff1  diff2 ξȤͭ⤷̵å, 
    ! ξƱǤ, η̤ rslt ŬѤޤ. 
    ! 2Ĥΰͭ, ⤦̵ξˤ
    ! 顼ȯޤ. 
    !
    use dc_error, only: StoreError, DC_EDIMTIME
    implicit none
    character(*), intent(in):: opr  ! 黻Ҥ̾
    type(DC_DIFFTIME), intent(in):: diff1, diff2
    type(DC_DIFFTIME), intent(inout):: rslt
  continue
    if (      (       diff1 % nondim_flag .and. .not. diff2 % nondim_flag ) &
      &  .or. ( .not. diff1 % nondim_flag .and.       diff2 % nondim_flag ) ) then
      call StoreError(DC_EDIMTIME, opr)
    end if
    rslt % nondim_flag = diff1 % nondim_flag
  end subroutine dcdate_nondimcheck

  function ParseTimeUnits(str) result(symbol)
    !
    !  *str* Ϳ줿ʸᤷ, ñ̤򼨤
    ! ܥ֤ޤ. 줾ʲʸñ̤ȤƲᤵޤ.
    ! ʸȾʸ϶̤ޤ.
    !
    ! ǯ         :: dc_date_types#UNIT_YEAR
    !          :: dc_date_types#UNIT_MONTH
    !          :: dc_date_types#UNIT_DAY
    !          :: dc_date_types#UNIT_HOUR
    ! ʬ         :: dc_date_types#UNIT_MIN
    !          :: dc_date_types#UNIT_SEC
    ! ̵ :: dc_date_types#UNIT_NONDIM
    !
    ! ֤륷ܥ () ϰʲ̤Ǥ. 
    !
    ! ǯ         :: dc_date_types#UNIT_SYMBOL_YEAR
    !          :: dc_date_types#UNIT_SYMBOL_MONTH
    !          :: dc_date_types#UNIT_SYMBOL_DAY
    !          :: dc_date_types#UNIT_SYMBOL_HOUR
    ! ʬ         :: dc_date_types#UNIT_SYMBOL_MIN
    !          :: dc_date_types#UNIT_SYMBOL_SEC
    ! ̵ :: dc_date_types#UNIT_SYMBOL_NONDIM
    !
    ! ˳ʤʸ *str* Ϳ, 
    ! dc_date_types#UNIT_SYMBOL_ERR ֤ޤ. 
    !
    use dc_types, only: TOKEN
    use dc_date_types, only: UNIT_YEAR, UNIT_MONTH, UNIT_DAY, &
      & UNIT_HOUR, UNIT_MIN, UNIT_SEC, UNIT_NONDIM, &
      & UNIT_SYMBOL_YEAR, UNIT_SYMBOL_MONTH, UNIT_SYMBOL_DAY, &
      & UNIT_SYMBOL_HOUR, UNIT_SYMBOL_MIN, UNIT_SYMBOL_SEC, &
      & UNIT_SYMBOL_NONDIM, UNIT_SYMBOL_ERR
    use dc_string, only: StriEq
    implicit none
    character(*), intent(in):: str
    integer:: symbol
    integer:: unit_str_size, i
    character(TOKEN):: unit
  continue
    unit = adjustl(str)
    unit_str_size = size(UNIT_NONDIM)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_NONDIM(i)))) then
        symbol = UNIT_SYMBOL_NONDIM
        return
      end if
    end do

    unit_str_size = size(UNIT_SEC)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_SEC(i)))) then
        symbol = UNIT_SYMBOL_SEC
        return
      end if
    end do

    unit_str_size = size(UNIT_MIN)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MIN(i)))) then
        symbol = UNIT_SYMBOL_MIN
        return
      end if
    end do

    unit_str_size = size(UNIT_HOUR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_HOUR(i)))) then
        symbol = UNIT_SYMBOL_HOUR
        return
      end if
    end do

    unit_str_size = size(UNIT_DAY)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_DAY(i)))) then
        symbol = UNIT_SYMBOL_DAY
        return
      end if
    end do

    unit_str_size = size(UNIT_MONTH)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MONTH(i)))) then
        symbol = UNIT_SYMBOL_MONTH
        return
      end if
    end do

    unit_str_size = size(UNIT_YEAR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_YEAR(i)))) then
        symbol = UNIT_SYMBOL_YEAR
        return
      end if
    end do

    symbol = UNIT_SYMBOL_ERR

  end function ParseTimeUnits

  character(TOKEN) function dcdate_parse_unit(str) result(unit)
    !
    ! Υ֥롼ʤΤ dc_date ⥸塼볰Ǥ
    ! ϻѤʤǤ.
    !
    !  *str* Ϳ줿ʸᤷ, ñ̤
    ! ֤ޤ. 줾ʲʸñ̤ȤƲᤵޤ.
    ! ʸȾʸ϶̤ޤ.
    ! ֤ʸϰʲʸƬʸǤ.
    ! (: *str*  'hrs.' Ϳ, dc_date_types#UNIT_HOUR
    ! Ƭʸ UNIT_HOUR(1) ֤ޤ.)
    !
    ! ǯ         :: dc_date_types#UNIT_YEAR
    !          :: dc_date_types#UNIT_MONTH
    !          :: dc_date_types#UNIT_DAY
    !          :: dc_date_types#UNIT_HOUR
    ! ʬ         :: dc_date_types#UNIT_MIN
    !          :: dc_date_types#UNIT_SEC
    ! ̵ :: dc_date_types#UNIT_NONDIM
    !
    ! ˳ʤʸ *str* Ϳ, ʸ֤ޤ.
    !
    use dc_types, only: TOKEN
    use dc_date_types, only: UNIT_YEAR, UNIT_MONTH, UNIT_DAY, &
      & UNIT_HOUR, UNIT_MIN, UNIT_SEC, UNIT_NONDIM
    use dc_string, only: StriEq
    implicit none
    character(*), intent(in):: str
    integer :: unit_str_size, i
  continue
    unit = adjustl(str)
    unit_str_size = size(UNIT_NONDIM)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_NONDIM(i)))) then
        unit = UNIT_NONDIM(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_SEC)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_SEC(i)))) then
        unit = UNIT_SEC(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MIN)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MIN(i)))) then
        unit = UNIT_MIN(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_HOUR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_HOUR(i)))) then
        unit = UNIT_HOUR(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_DAY)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_DAY(i)))) then
        unit = UNIT_DAY(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_MONTH)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_MONTH(i)))) then
        unit = UNIT_MONTH(1)
        return
      end if
    end do

    unit_str_size = size(UNIT_YEAR)
    do i = 1, unit_str_size
      if (StriEq(trim(unit), trim(UNIT_YEAR(i)))) then
        unit = UNIT_YEAR(1)
        return
      end if
    end do

    unit = ''

  end function dcdate_parse_unit

  type(DC_DATETIME) function dcdate_add_ft(diff, time) result(result)
    !
    ! 2 Ĥ (DC_DATETIME ) ⤷
    !  (DC_DIFFTIME )βûԤޤ.
    !
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    type(DC_DATETIME), intent(in):: time
    type(DC_SCALED_SEC):: time_year, time_mon, time_day, time_sec
    integer:: time_caltype
    character(6):: time_zone
  continue
    call Eval(time, sclyear = time_year, sclmon = time_mon, &
      & sclday = time_day, sclsec = time_sec, &
      & caltype = time_caltype, zone = time_zone)
    call DCDateTimeCreate(result, sclyear = time_year, &
      & sclmon = time_mon + diff % mon, &
      & sclday = time_day + diff % day, &
      & sclsec = time_sec + diff % sec, &
      & caltype = time_caltype, zone = time_zone)
  end function dcdate_add_ft

  type(DC_DATETIME) function dcdate_add_tf(time, diff) result(result)
    use dc_types, only: DP
    implicit none
    type(DC_DATETIME), intent(in):: time
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = dcdate_add_ft(diff, time)
  end function dcdate_add_tf

  type(DC_DIFFTIME) function dcdate_add_ff(diff1, diff2) result(result)
    use dc_scaledsec, only: operator(+)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    result % mon = diff1 % mon + diff2 % mon
    result % day = diff1 % day + diff2 % day
    result % sec = diff1 % sec + diff2 % sec
    result % day_seconds = diff1 % day_seconds
    call dcdate_nondimcheck('dc_date#operator(+)', diff1, diff2, result)
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_add_ff

  type(DC_DIFFTIME) function dcdate_add_fd(diff, sec) result(result)
    use dc_scaledsec, only: operator(+)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: sec
  continue
    result % mon = diff % mon
    result % day = diff % day
    result % sec = diff % sec + sec
    result % day_seconds = diff % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_add_fd

  type(DC_DIFFTIME) function dcdate_add_fr(diff, sec) result(result)
    use dc_scaledsec, only: operator(+)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: sec
  continue
    result = diff + real( sec, DP )
  end function dcdate_add_fr

  type(DC_DIFFTIME) function dcdate_add_fi(diff, sec) result(result)
    use dc_scaledsec, only: operator(+)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: sec
  continue
    result = diff + real( sec, DP )
  end function dcdate_add_fi

  type(DC_DATETIME) function dcdate_sub_tf(time, diff) result(result)
    !
    ! 2 Ĥ (DC_DATETIME ) ⤷
    !  (DC_DIFFTIME )θԤޤ.
    !
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_DATETIME), intent(in):: time
    type(DC_DIFFTIME), intent(in):: diff
    type(DC_SCALED_SEC):: time_year, time_mon, time_day, time_sec
    integer:: time_caltype
    character(6):: time_zone
  continue
    call Eval(time, &
      & sclyear = time_year, sclmon = time_mon, sclday = time_day, &
      & sclsec = time_sec, caltype = time_caltype, zone = time_zone )
    call DCDateTimeCreate(result, &
      & sclyear = time_year, &
      & sclmon = time_mon - diff % mon, &
      & sclday = time_day - diff % day, &
      & sclsec = time_sec - diff % sec, &
      & caltype = time_caltype, zone = time_zone)
  end function dcdate_sub_tf

  type(DC_DIFFTIME) function dcdate_sub_tt(time1, time2) result(result)
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
  continue
    result % day = time1 % day - time2 % day
    result % sec = time1 % sec - time2 % sec &
      & + EvalSclSec(ZoneToDiff(time1 % zone) - ZoneToDiff(time2 % zone))
    result % day_seconds = time1 % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_sub_tt

  type(DC_DIFFTIME) function dcdate_sub_ff(diff1, diff2) result(result)
    use dc_scaledsec, only: operator(-)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    result % mon = diff1 % mon - diff2 % mon
    result % day = diff1 % day - diff2 % day
    result % sec = diff1 % sec - diff2 % sec
    result % day_seconds = diff1 % day_seconds
    call dcdate_nondimcheck('dc_date#operator(-)', diff1, diff2, result)
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_sub_ff

  type(DC_DIFFTIME) function dcdate_sub_fd(diff, sec) result(result)
    use dc_scaledsec, only: operator(-)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: sec
  continue
    result % mon = diff % mon
    result % day = diff % day
    result % sec = diff % sec - sec
    result % day_seconds = diff % day_seconds
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_sub_fd

  type(DC_DIFFTIME) function dcdate_sub_fr(diff, sec) result(result)
    use dc_scaledsec, only: operator(-)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: sec
  continue
    result = diff - real( sec, DP )
  end function dcdate_sub_fr

  type(DC_DIFFTIME) function dcdate_sub_fi(diff, sec) result(result)
    use dc_scaledsec, only: operator(-)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: sec
  continue
    result = diff - real( sec, DP )
  end function dcdate_sub_fi

  type(DC_DIFFTIME) function dcdate_mul_if(factor, diff) result(result)
    !
    !  *diff*  *facter* Ȥ軻̤֤ޤ.
    !
    use dc_scaledsec, only: operator(*)
    implicit none
    integer, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result % mon = factor * diff % mon
    result % day = factor * diff % day
    result % sec = factor * diff % sec
    result % day_seconds = diff % day_seconds
    result % nondim_flag = diff % nondim_flag
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_mul_if

  type(DC_DIFFTIME) function dcdate_mul_fi(diff, factor) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: factor
  continue
    result = dcdate_mul_if(factor, diff)
  end function dcdate_mul_fi

  type(DC_DIFFTIME) function dcdate_mul_rf(factor, diff) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    use dc_types, only: DP
    implicit none
    real, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = dcdate_mul_df(real(factor, DP), diff)
  end function dcdate_mul_rf

  type(DC_DIFFTIME) function dcdate_mul_fr(diff, factor) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: factor
  continue
    result = dcdate_mul_rf(factor, diff)
  end function dcdate_mul_fr

  type(DC_DIFFTIME) function dcdate_mul_df(factor, diff) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    use dc_types, only: DP
    use dc_date_types, only: CYCLIC_MDAYS
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    real(DP), intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
    type(DC_SCALED_SEC):: month, day
  continue
    month = factor * diff % mon
    result % mon = int(month)
    day = factor * diff % day + int(CYCLIC_MDAYS * (month - result % mon))
    result % day = int(day)
    result % sec = &
      & factor * diff % sec + (day - result % day) * diff % day_seconds
    result % day_seconds = diff % day_seconds
    result % nondim_flag = diff % nondim_flag
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_mul_df

  type(DC_DIFFTIME) function dcdate_mul_fd(diff, factor) result(result)
    !
    !   : ܤȶṲ̄ˤʤ뤪줬ޤ
    use dc_types, only: DP
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: factor
  continue
    result = dcdate_mul_df(factor, diff)
  end function dcdate_mul_fd

  type(DC_DIFFTIME) function dcdate_div_fi(diff, denominator) result(result)
    !
    !  *diff*  *denominator* ǽ̤֤ޤ.
    !
    !   : ȶṲ̄ˤʤ뤪줬ޤ
    use dc_date_types, only: CYCLIC_MDAYS
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modscl => mod, modulo, int, abs, sign
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: denominator
  continue
    result % mon = int( diff % mon / denominator )
    ! ζŪ겼ñ̤ǤԤʤ
    result % day = &
      &   int( diff % day / denominator ) &
      & + int( (CYCLIC_MDAYS * modscl(diff % mon, denominator)) / denominator )
    result % sec = diff % sec / denominator + &
      & (diff % day_seconds * modscl(diff % day, denominator)) / &
      & denominator
    result % nondim_flag = diff % nondim_flag
  end function dcdate_div_fi

  type(DC_DIFFTIME) function dcdate_div_fr(diff, denominator) result(result)
    !
    !   : ȶṲ̄ˤʤ뤪줬ޤ
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: denominator
  continue
    result = dcdate_div_fd(diff, real(denominator, DP))
  end function dcdate_div_fr

  type(DC_DIFFTIME) function dcdate_div_fd(diff, denominator) result(result)
    !
    !   : ȶṲ̄ˤʤ뤪줬ޤ
    use dc_date_types, only: CYCLIC_MDAYS
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: denominator
    type(DC_SCALED_SEC):: month, day
  continue
    month = int( diff % mon / denominator )
    result % mon = int(month)
    day =   int( diff % day / denominator ) &
      &   + int(CYCLIC_MDAYS * (month - result % mon))
    result % day = int(day)
    result % sec = &
      & diff % sec / denominator + (day - result % day) * diff % day_seconds
    result % day_seconds = diff % day_seconds
    result % nondim_flag = diff % nondim_flag
    call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
  end function dcdate_div_fd

  real(DP) function dcdate_div_ff(diff1, diff2) result(result)
    !
    !   : κߤ϶Ṳ̄ˤʤ뤪줬ޤ
    use dc_date_types, only: CYCLIC_MDAYS
    use dc_scaledsec, only: DC_SCALED_SEC, assignment(=), &
      & operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    ! бɤɬפ?
    result = &
      & (diff1 % day_seconds * (CYCLIC_MDAYS * diff1 % mon + diff1 % day) &
      & + diff1 % sec) / &
      & (diff2 % day_seconds * (CYCLIC_MDAYS * diff2 % mon + diff2 % day) &
      & + diff2 % sec)
  end function dcdate_div_ff

  type(DC_DIFFTIME) function dcdate_mod_ff(diff1, diff2) result(result)
    !
    !  <b>diff1</b>  <b>diff2</b> ǽݤ;֤ޤ.
    !
    !  : κߤ϶Ṳ̄ˤʤ뤪줬ޤ
    !
    use dc_date_types, only: CYCLIC_MDAYS
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(==), operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modscl => mod, modulo, int, abs, sign
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
    type(DC_SCALED_SEC):: sec1, sec2
    type(DC_SCALED_SEC):: zero_sec
  continue
    result % day_seconds = diff1 % day_seconds
    if (diff1 % day == zero_sec .and. diff2 % day == zero_sec .and. &
      & diff1 % sec == zero_sec .and. diff2 % sec == zero_sec) then
      result % mon = modscl(diff1 % mon, diff2 % mon)
      result % day = zero_sec
      result % sec = zero_sec
    else if (diff1 % sec == zero_sec .and. diff2 % sec == zero_sec) then
      result % mon = zero_sec
      result % day = modscl((CYCLIC_MDAYS * diff1 % mon + diff1 % day), &
        & (CYCLIC_MDAYS * diff2 % mon + diff2 % day))
      result % sec = zero_sec
    else
      sec1 = diff1 % day_seconds * (CYCLIC_MDAYS * diff1 % mon + diff1 % day) &
        & + diff1 % sec
      sec2 = diff2 % day_seconds * (CYCLIC_MDAYS * diff2 % mon + diff2 % day) &
        & + diff2 % sec
      result % sec = modscl(sec1, sec2)
      result % day = zero_sec
      result % mon = zero_sec
      call dcdate_normalize(result % day, result % sec, result % day_seconds, result % nondim_flag)
    endif
    call dcdate_nondimcheck('dc_date#mod', diff1, diff2, result)
  end function dcdate_mod_ff

  logical function dcdate_gt_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! ʤǤ, .true. ֤ޤ.
    !
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(==), operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), operator(-), operator(*), operator(/), &
      & modulo, int, abs, sign
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
    type(DC_SCALED_SEC):: year1, year2, time1_sec, time2_sec
  continue
    call Eval(time1, sclyear=year1)
    call Eval(time2, sclyear=year2)
    if (year1 > year2) then
      result = .true.
    elseif (year1 < year2) then
      result = .false.
    else
      time1_sec = EvalSclSec(time1) + EvalSclSec(ZoneToDiff(time1 % zone))
      time2_sec = EvalSclSec(time2) + EvalSclSec(ZoneToDiff(time2 % zone))
      if (time1_sec > time2_sec) then
        result = .true.
      else
        result = .false.
      end if
    end if
  end function dcdate_gt_tt

  logical function dcdate_gt_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    use dc_date_types, only: CYCLIC_MDAYS
    use dc_scaledsec, only: &
      & operator(<), operator(>), operator(<=), operator(>=), operator(==)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if ( diff1 % day_seconds == diff2 % day_seconds ) then

      if ( diff1 % mon > diff2 % mon ) then
        result = .true.  ; return
      elseif ( diff1 % mon < diff2 % mon ) then
        result = .false. ; return
      end if
      if ( diff1 % day > diff2 % day ) then
        result = .true.  ; return
      elseif ( diff1 % day < diff2 % day ) then
        result = .false. ; return
      end if
      if ( diff1 % sec > diff2 % sec ) then
        result = .true.  ; return
      elseif ( diff1 % sec < diff2 % sec ) then
        result = .false. ; return
      end if
      result = .false.
    else

      if (EvalSec(diff1) > EvalSec(diff2)) then
        result = .true.
      else
        result = .false.
      end if
    end if
  end function dcdate_gt_ff

  logical function dcdate_gt_fi(diff, factor) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: factor
  continue
    result = EvalSec(diff) > factor
  end function dcdate_gt_fi

  logical function dcdate_gt_if(factor, diff) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    use dc_date_types, only: CYCLIC_MDAYS
    implicit none
    integer, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = factor > EvalSec(diff)
  end function dcdate_gt_if


  logical function dcdate_lt_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! ʤǤ, .true. ֤ޤ.
    !
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(==), operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+)
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
    type(DC_SCALED_SEC):: year1, year2, time1_sec, time2_sec
  continue
    call Eval(time1, sclyear=year1)
    call Eval(time2, sclyear=year2)
    if (year1 < year2) then
      result = .true.
    elseif (year1 > year2) then
      result = .false.
    else
      time1_sec = EvalSclSec(time1) + EvalSclSec(ZoneToDiff(time1 % zone))
      time2_sec = EvalSclSec(time2) + EvalSclSec(ZoneToDiff(time2 % zone))
      if (time1_sec < time2_sec) then
        result = .true.
      else
        result = .false.
      end if
    end if
  end function dcdate_lt_tt

  logical function dcdate_lt_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    use dc_scaledsec, only: &
      & operator(<), operator(>), operator(<=), operator(>=), operator(==)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if ( diff1 % day_seconds == diff2 % day_seconds ) then

      if ( diff1 % mon < diff2 % mon ) then
        result = .true.  ; return
      elseif ( diff1 % mon > diff2 % mon ) then
        result = .false. ; return
      end if
      if ( diff1 % day < diff2 % day ) then
        result = .true.  ; return
      elseif ( diff1 % day > diff2 % day ) then
        result = .false. ; return
      end if
      if ( diff1 % sec < diff2 % sec ) then
        result = .true.  ; return
      elseif ( diff1 % sec > diff2 % sec ) then
        result = .false. ; return
      end if
      result = .false.
    else

      if (EvalSec(diff1) < EvalSec(diff2)) then
        result = .true.
      else
        result = .false.
      end if
    end if

  end function dcdate_lt_ff

  logical function dcdate_lt_fi(diff, factor) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: factor
  continue
    result = EvalSec(diff) < factor
  end function dcdate_lt_fi

  logical function dcdate_lt_if(factor, diff) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! 礭, .true. ֤ޤ.
    !
    implicit none
    integer, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = factor < EvalSec(diff)
  end function dcdate_lt_if

  logical function dcdate_ge_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! ʤǤ礫⤷, .true. ֤ޤ.
    !
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
  continue
    result = .not. time1 < time2
  end function dcdate_ge_tt

  logical function dcdate_ge_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! 礭礫⤷, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    result = .not. diff1 < diff2
  end function dcdate_ge_ff

  logical function dcdate_ge_fi(diff, factor) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! 礭礫⤷, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: factor
  continue
    result = .not. diff < factor
  end function dcdate_ge_fi

  logical function dcdate_ge_if(factor, diff) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! 礭礫⤷, .true. ֤ޤ.
    !
    implicit none
    integer, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = .not. factor < diff
  end function dcdate_ge_if


  logical function dcdate_le_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! ʤǤ礫⤷, .true. ֤ޤ.
    !
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
  continue
    result = .not. time1 > time2
  end function dcdate_le_tt

  logical function dcdate_le_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! 礭礫⤷, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    result = .not. diff1 > diff2
  end function dcdate_le_ff

  logical function dcdate_le_fi(diff, factor) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! 礭礫⤷, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: factor
  continue
    result = .not. diff > factor
  end function dcdate_le_fi

  logical function dcdate_le_if(factor, diff) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 2 ܤΰ˳Ǽ 1 ܤΰ˳Ǽ
    ! 礭礫⤷, .true. ֤ޤ.
    !
    implicit none
    integer, intent(in):: factor
    type(DC_DIFFTIME), intent(in):: diff
  continue
    result = .not. factor > diff
  end function dcdate_le_if


  type(DC_DATETIME) function dcdate_max_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤ, ʤǤ֤ޤ. 
    !
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
  continue
    if ( time1 > time2 ) then
      result = time1
    else
      result = time2
    end if
  end function dcdate_max_tt

  type(DC_DIFFTIME) function dcdate_max_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤ, 礭֤ޤ. 
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if ( diff1 > diff2 ) then
      result = diff1
    else
      result = diff2
    end if
    call dcdate_nondimcheck('dc_date#max', diff1, diff2, result)
  end function dcdate_max_ff


  type(DC_DATETIME) function dcdate_min_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤ, ٤Ƥ֤ޤ. 
    !
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
  continue
    if ( time1 < time2 ) then
      result = time1
    else
      result = time2
    end if
  end function dcdate_min_tt

  type(DC_DIFFTIME) function dcdate_min_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤ, 꾮֤ޤ. 
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if ( diff1 < diff2 ) then
      result = diff1
    else
      result = diff2
    end if
    call dcdate_nondimcheck('dc_date#min', diff1, diff2, result)
  end function dcdate_min_ff

  logical function dcdate_eq_tt(time1, time2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! Ʊ, .true. ֤ޤ.
    !
    use dc_scaledsec, only: DC_SCALED_SEC, &
      & operator(==), operator(<), operator(>), operator(<=), operator(>=), &
      & operator(+), assignment(=)
    implicit none
    type(DC_DATETIME), intent(in):: time1, time2
    type(DC_SCALED_SEC):: year1, year2, time1_sec, time2_sec
  continue
    call Eval(time1, sclyear=year1)
    call Eval(time2, sclyear=year2)
    time1_sec = EvalSclSec(time1) + EvalSclSec(ZoneToDiff(time1 % zone))
    time2_sec = EvalSclSec(time2) + EvalSclSec(ZoneToDiff(time2 % zone))
    if (year1 == year2 .and. time1_sec == time2_sec) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_tt


  logical function dcdate_eq_ff(diff1, diff2) result(result)
    !
    ! 2 ĤΰӤޤ.
    ! 1 ܤΰ˳Ǽ 2 ܤΰ˳Ǽ
    ! Ʊ, .true. ֤ޤ.
    !
    use dc_scaledsec, only: operator(==)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff1, diff2
  continue
    if (       diff1 % mon == diff2 % mon &
      &  .and. diff1 % day == diff2 % day &
      &  .and. diff1 % sec == diff2 % sec   ) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_ff

  logical function dcdate_eq_if(i, diff) result(result)
    !
    !  *diff*  *i* ɤӤޤ. *diff*
    ! ÿ˴ͤ *i* Ȥ, .true. ֤ޤ.
    !
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: i
  continue
    result = dcdate_eq_rf(real(i), diff)
  end function dcdate_eq_if

  logical function dcdate_eq_fi(diff, i) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    integer, intent(in):: i
  continue
    result = dcdate_eq_if(i, diff)
  end function dcdate_eq_fi

  logical function dcdate_eq_rf(r, diff) result(result)
    !
    !  *diff*  *r* ɤӤޤ. *diff*
    ! ÿ˴ͤ *r* Ȥ, .true. ֤ޤ.
    !
    use dc_scaledsec, only: operator(==)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: r
  continue
    if (EvalSclSec(diff) == r) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_rf

  logical function dcdate_eq_fr(diff, r) result(result)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real, intent(in):: r
  continue
    result = dcdate_eq_rf(r, diff)
  end function dcdate_eq_fr

  logical function dcdate_eq_df(d, diff) result(result)
    !
    !  *diff*  *d* ɤӤޤ. *diff*
    ! ÿ˴ͤ *d* Ȥ, .true. ֤ޤ.
    !
    use dc_types, only: DP
    use dc_scaledsec, only: operator(==)
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: d
  continue
    if (EvalSclSec(diff) == d) then
      result = .true.
    else
      result = .false.
    end if
  end function dcdate_eq_df

  logical function dcdate_eq_fd(diff, d) result(result)
    use dc_types, only: DP
    implicit none
    type(DC_DIFFTIME), intent(in):: diff
    real(DP), intent(in):: d
  continue
    result = dcdate_eq_df(d, diff)
  end function dcdate_eq_fd

end module dc_date
