!== ա˴ؤ빽¤ǡ
!== Data types for date and time
!
! Authors::   Yasuhiro MORIKAWA, Eizi TOYODA
! Version::   $Id: dc_date_types.f90,v 1.4 2008-10-02 18:29:34 morikawa Exp $
! Tag Name::  $Name: gtool5-20081005 $
! Copyright:: Copyright (C) GFD Dennou Club, 2000-2005. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]

module dc_date_types
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! dc_date Ѥ빽¤Τѿ, Ƥ⥸塼Ǥ. 
  !
  ! ޤˡ˴ؤƤޤ. 
  !
  ! Derived types, variables, parameters for "dc_date" are defined 
  ! in this module. 
  ! 
  ! Information of calender are managed too.
  !
  !== Derived types List
  !
  ! DC_DATETIME :: äФջɽޤ. 
  ! DC_DIFFTIME :: X , X , ʤɤɽޤ. 
  !
  !== Characters list for unit
  ! 
  ! UNIT_NONDIM       :: .
  ! UNIT_SEC          :: .
  ! UNIT_MIN          :: .
  ! UNIT_HOUR         :: .
  ! UNIT_DAY          :: .
  ! UNIT_MONTH        :: .
  ! UNIT_YEAR         :: .
  !
  !== Symbols for unit
  ! 
  ! UNIT_SYMBOL_NONDIM :: .
  ! UNIT_SYMBOL_SEC    :: .
  ! UNIT_SYMBOL_MIN    :: .
  ! UNIT_SYMBOL_HOUR   :: .
  ! UNIT_SYMBOL_DAY    :: .
  ! UNIT_SYMBOL_MONTH  :: .
  ! UNIT_SYMBOL_YEAR   :: .
  ! UNIT_SYMBOL_ERR    :: .
  !
  !== Parameters for calender
  !
  ! CAL_CYCLIC        :: .
  ! CAL_NOLEAP        :: .
  ! CAL_JULIAN        :: .
  ! CAL_GREGORIAN     :: .
  !
  !== Parameters for conversion of year-month-day-hour-min-sec
  ! 
  ! CYCLIC_MDAYS      :: .
  ! DAY_SECONDS_EARTH :: .
  ! MIN_SECONDS       :: .
  ! HOUR_SECONDS      :: .
  ! YEAR_MONTHS       :: .
  ! YEAR_DAYS         :: .
  ! FOUR_YEARS        :: .
  ! FOUR_CENTURY      :: .
  ! PREPARED_CALTYPES :: .
  !
  !
  use dc_types, only: DP, STRING
  use dc_scaledsec, only: DC_SCALED_SEC

  implicit none

  private
  public:: DC_DATETIME, DC_DIFFTIME
  public:: UNIT_NONDIM, UNIT_SEC, UNIT_MIN, UNIT_HOUR, UNIT_DAY, UNIT_MONTH, UNIT_YEAR
  public:: UNIT_SYMBOL_NONDIM, UNIT_SYMBOL_SEC, UNIT_SYMBOL_MIN
  public:: UNIT_SYMBOL_HOUR, UNIT_SYMBOL_DAY, UNIT_SYMBOL_MONTH, UNIT_SYMBOL_YEAR
  public:: UNIT_SYMBOL_ERR
  public:: CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN
  public:: CYCLIC_MDAYS, DAY_SECONDS_EARTH, MIN_SECONDS, HOUR_SECONDS
  public:: YEAR_MONTHS, YEAR_DAYS, FOUR_YEARS, FOUR_CENTURY
  public:: PREPARED_CALTYPES
  public:: caltype, day_seconds, day_seconds_scl, flag_set_day_seconds_scl

  !-------
  ! ˡ

  integer, parameter:: CAL_CYCLIC = 1   ! 1  30.6  (CYCLIC_MDAYS)
                                        ! Ȥ.
                                        ! (: 0 ܤ 1  30 (30.6),
                                        ! 1 ܤ 1  31 (61.2),
                                        ! 2 ܤ 1  30 (91.8),
                                        ! 3 ܤ 1  31 (122.4),
                                        ! 4 ܤ 1  31 (153.0) ...)
                                        !
                                        ! Ūʻ֤Ǽ¸Ԥ
                                        ! ˻Ѥ뤳ȤꤷƤ
                                        ! ޤ.
                                        !
  integer, parameter:: CAL_NOLEAP = 2   ! 1 ǯ 365 
                                        !
  integer, parameter:: CAL_JULIAN = 3   ! ꥦ
                                        !
  integer, parameter:: CAL_GREGORIAN = 4! 쥴ꥪ
                                        !
  integer, parameter:: PREPARED_CALTYPES(0:3) = &
    & (/CAL_CYCLIC, CAL_NOLEAP, CAL_JULIAN, CAL_GREGORIAN/)

  integer, save:: caltype = CAL_GREGORIAN ! ǥեȤ

  !-------
  ! ñ̴֤δط

  real(DP), parameter:: CYCLIC_MDAYS = 30.6_DP    ! CAL_CYCLIC ǻѤ
                                                  ! 1 .
                                                  ! ޤ DC_DIFFTIME 
                                                  ! 1 ˤ
                                                  ! Ѥޤ.

  integer, parameter:: MIN_SECONDS  = 60          ! 1 ʬÿ
  integer, parameter:: HOUR_SECONDS = 3600        ! 1 ֤ÿ
  real(DP), parameter:: DAY_SECONDS_EARTH  = 86400.0_DP
                                                  ! ϵ 1 ÿ
  real(DP), save :: day_seconds = DAY_SECONDS_EARTH
                                                  ! 1 ÿ
  type(DC_SCALED_SEC), save :: day_seconds_scl
                                                  ! 1 ÿ
  logical, save :: flag_set_day_seconds_scl = .false.
                                                  ! 1 ÿ
  integer, parameter:: YEAR_DAYS = 365            ! 1 ǯ (ǯ) 
  integer, parameter:: YEAR_MONTHS = 12           ! 1 ǯη
  integer, parameter:: FOUR_YEARS = YEAR_DAYS * 4 + 1
                                                  ! 4 ǯ
  integer, parameter:: FOUR_CENTURY = YEAR_DAYS * 400 + 97
                                                  ! 1 

  !-------
  ! ñ̤Ȥǧʸ

  character(*), parameter, dimension(1) :: UNIT_NONDIM = (/ &
    & '1' /)                                       ! ̵֤ñ̤򼨤ʸ

  character(*), parameter, dimension(8) :: UNIT_SEC = (/ &
    & 'seconds', 'second ', 'secs.  ', 'secs   ', &
    & 'sec.   ', 'sec    ', 's.     ', 's      '/) ! äñ̤򼨤ʸ

  character(*), parameter, dimension(4) :: UNIT_MIN = (/ &
    & 'minutes', 'minute ', 'min.   ', 'min    '/) ! ʬñ̤򼨤ʸ
  character(*), parameter, dimension(8) :: UNIT_HOUR = (/ &
    & 'hours', 'hour ', 'hrs. ', 'hrs  ', &
    & 'hr.  ', 'hr   ', 'h.   ', 'h    '/)         ! ñ̤򼨤ʸ
  character(*), parameter, dimension(4) :: UNIT_DAY = (/ &
    & 'days', 'day ', 'd.  ', 'd   '/)             ! ñ̤򼨤ʸ
  character(*), parameter, dimension(6) :: UNIT_MONTH = (/ &
    & 'months', 'month ', 'mon.  ', &
    & 'mon   ', 'mo.   ', 'mo    '/)               ! ñ̤򼨤ʸ
  character(*), parameter, dimension(4) :: UNIT_YEAR = (/ &
    & 'years', 'year ', 'yr.  ', 'yr   '/)         ! ǯñ̤򼨤ʸ

  !-------
  ! ñ̤Υܥ

  integer, parameter:: UNIT_SYMBOL_ERR    = -1 ! ̵ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_NONDIM = 1 ! ̵»֤ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_SEC    = 2 ! äñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_MIN    = 3 ! ʬñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_HOUR   = 4 ! ֤ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_DAY    = 5 ! ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_MONTH  = 6 ! ñ̤򼨤ܥ
  integer, parameter:: UNIT_SYMBOL_YEAR   = 7 ! ǯñ̤򼨤ܥ

  type DC_DATETIME
    ! äФջɽޤ.
    !
    ! ι¤ǡѿѤݤɬѿ
    ! dc_date#Create ޤ dc_date#assignment(=)
    ! ˤäƽƤ. ޤ, *day*, *sec* ʤɤѿ
    ! ľѹʤǤ.
    !
    ! ˡ dc_date  "List"  "Usage" 򻲾ȤƤ.
    !
    sequence
    integer :: caltype = CAL_GREGORIAN ! ˡ
    type(DC_SCALED_SEC):: day          ! 
    type(DC_SCALED_SEC):: sec          ! 
    logical:: dummy = .false.
                              ! 뤿Υߡѿ. 
                              ! Dummy variable for boundary alignment
    type(DC_SCALED_SEC):: day_seconds  ! 1 ÿ
    character(STRING) :: zone = '+00:00' ! UTC λ
  end type DC_DATETIME

  type DC_DIFFTIME
    ! X , X , ʤɤɽ뤿ΥǡǤ.
    !
    ! ι¤ǡѿѤݤɬѿ
    ! dc_date#Create ޤ dc_date#assignment(=)
    ! ˤäƽƤ. ޤ, *day*, *sec* ʤɤѿ
    ! ľѹʤǤ.
    !
    ! ˡ dc_date  "List"  "Usage" 򻲾ȤƤ.
    !
    ! ʤ, 1  dc_date_types#CYCLIC_MDAYS ȴޤ.
    !
    !--
    !== ȯԸ
    !
    ! 1פȤǰб뤿ᡢmonth ޤ
    !
    ! : դȰäƷ normalize 뤳ȤϤǤޤ
    !++
    sequence
    type(DC_SCALED_SEC):: mon ! . Month
    type(DC_SCALED_SEC):: day ! . Day
    type(DC_SCALED_SEC):: sec !  ޤ̵. Seconds or nondimensional time
    logical:: dummy0 = .false.
                              ! 뤿Υߡѿ. 
                              ! Dummy variable for boundary alignment
    type(DC_SCALED_SEC):: day_seconds  ! 1 ÿ
                              ! 1 ÿ. Seconds of day
    logical:: nondim_flag = .false.
                              ! ̵򼨤ե饰. 
                              ! Flag for nondimensional number
    logical:: dummy1 = .false.
                              ! 뤿Υߡѿ. 
                              ! Dummy variable for boundary alignment

!!$    real(DP):: sec_scale_factor
!!$                              ! 1.0 ʲ sec Ϳ줿ݤ, 
!!$                              ! ݤˤä
!!$                              ! sec ΤɤΥե
!!$                              ! (¸Ūǽ)
  end type DC_DIFFTIME

end module dc_date_types
