! GTContSave - }ϐƂĕۑ
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTContSave(cont, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_CONTOURS
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, get_attr, add_member, &
        & Inquire
    use dc_string
    use dc_types, only: STRING
    implicit none
    type(GT_CONTOURS), intent(inout):: cont
    type(VSTRING), intent(in), optional:: name
    type(VSTRING), intent(out), optional:: name_result
    type(VSTRING):: member
    character(STRING):: member_c, url, vname, title
    type(GT_VARIABLE):: var
    character(len = *), parameter:: GTCT = "gt_graph_contours_"
continue
    if (present(name)) then
        vname = name
    else
        call GTGraphSaveName(result=vname)
    endif
    call get_attr(cont%var, "long_name", title)
    title = "contours of " // title
    call Create(var, trim(vname), xtype="int", overwrite=.TRUE., &
        long_name=trim(title))
    call Put_Attr(var, "gt_structure_class", "contours")
    call Put_Attr(var, GTCT // "draw_shade", cont%shade)
    call Put_Attr(var, GTCT // "draw_contours", cont%contours)
    if (cont%interval /= 0.0) then
        call Put_Attr(var, GTCT // "interval", (/cont%interval/))
    endif
    if (cont%icycle /= 0) then
        call Put_Attr(var, GTCT // "thick_cycle", (/cont%icycle/))
    endif
    if (associated(cont%levels)) then
        call Put_Attr(var, GTCT // "levels", cont%levels)
    endif
    if (associated(cont%skiplevels)) then
        call Put_Attr(var, GTCT // "skiplevels", cont%skiplevels)
    endif
    if (cont%map /= "") then
        call Put_Attr(var, "gt_graph_draw_map", trim(cont%map))
    endif
    ! experimental
    if (associated(cont%tones)) then
        call Put_Attr(var, GTCT // "tone_number", cont%tones)
    endif

    ! }̃oɂȂĂ̂̏o
    call Inquire(cont%var, url=url)
    call add_member(var, url, link_name="data")
    if (associated(cont%v_axis)) then
        if (cont%v_axis%saved /= "") then
            call add_member(var, cont%v_axis%saved, link_name="vaxis")
        else
            call Save(cont%v_axis, resultname=member)
            member_c = member
            call add_member(var, member_c, link_name="vaxis")
        endif
    endif
    if (associated(cont%h_axis)) then
        if (cont%h_axis%saved /= "") then
            call add_member(var, cont%h_axis%saved, link_name="haxis")
        else
            call Save(cont%h_axis, resultname=member)
            member_c = member
            call add_member(var, member_c, link_name="haxis")
        endif
    endif
    
    call Close(var)
    print *, trim(title), " stored at ", trim(vname), "."
    if (present(name_result)) name_result = vname
end subroutine
