#!/bin/sh
# test of gtattr

set -e

ncgen -b - <<EOF
netcdf xx {
variables:
	int	a;
}
EOF

../gtattr/gtattr xx.nc@a ii=4 ir=432.97 it=quux > /dev/null
../gtattr/gtattr xx.nc@a -type=int i=4 > /dev/null
../gtattr/gtattr xx.nc@a -type=real r=432.97 > /dev/null
../gtattr/gtattr xx.nc@a -type=double d=432.97 > /dev/null
../gtattr/gtattr xx.nc@a -type=text t=432.97 > /dev/null

ncdump xx.nc > xx.cdl

diff xx.cdl - <<EOF
netcdf xx {
variables:
	int a ;
		a:ii = "4" ;
		a:ir = "432.97" ;
		a:it = "quux" ;
		a:i = 4 ;
		a:r = 432.97f ;
		a:d = 432.97 ;
		a:t = "432.97" ;
data:

 a = _ ;
}
EOF

rm -f xx.nc xx.cdl
echo okay
