! Copyright (C) GFD Dennou Club, 2000.  All rights reserved.

subroutine GTContLoad(Cont, var)
    use gtgraph_types, only: GT_CONTOURS
    use gtdata_types, only: GT_VARIABLE
    use gtgraph_generic, only: Load
    use gtdata_generic  ! ςg珑̂͂
    use dc_types, only: STRING
    use dc_error
    implicit none
    type(GT_CONTOURS), intent(out):: Cont
    type(GT_VARIABLE), intent(in):: var
    character(STRING):: varname
    ! N data ł邱Ƃ
    call get_attr(var, "gt_structure_link_data", varname)
    if (varname == "") then
        call StoreError(GT_EBADLINK, "GTContLoad(data variable)")
        return
    endif
    call Open(cont%var, varname)
    cont%contours = attr_true(var, 'gt_contours_draw_contours', default=.TRUE.)
    cont%shade = attr_true(var, 'gt_contours_draw_shade', default=.FALSE.)
    allocate(cont%h_axis, cont%v_axis)
    call get_attr(var, "gt_structure_link_haxis", varname)
    call Load(cont%h_axis, varname)
    call get_attr(var, "gt_structure_link_vaxis", varname)
    call Load(cont%v_axis, varname)
    ! IvV̏
    call get_attr(var, 'gt_contours_interval', cont%interval, default=0.0)
    call get_attr(var, 'gt_contours_base_level', cont%base, default=0.0)
    call get_attr(var, 'gt_contours_major_contour_cycle', cont%icycle, default=0)
    call get_attr(var, 'gt_contours_levels', cont%levels)
    call get_attr(var, 'gt_contours_skiplevels', cont%skiplevels)
    call get_attr(var, 'gt_contours_tones', cont%tones)
    call get_attr(var, 'gt_contours_map', cont%map, default="")
end subroutine

