! GTAxisSave - WϐƂĕۑ
! Copyright (C) GFD Dennou Club, 2000.  All rights reserved

subroutine GTAxisSave(axis, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_Axis
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, add_member, Inquire
    use dc_string
    use dc_types, only: STRING
    implicit none
    type(GT_AXIS), intent(inout):: axis
    type(VSTRING), intent(in), optional:: name
    type(VSTRING), intent(out), optional:: name_result
    character(STRING):: url, vname, title
    type(GT_VARIABLE):: var
continue
    if (present(name)) then
        vname = name
    else
        call GTGraphSaveName(result=vname)
    endif
    if (axis%vertical) then
        title = "vertical axis of " // trim(axis%title)
    else
        title = "horizontal axis of " // trim(axis%title)
    endif
    call Create(var, trim(vname), xtype="int", overwrite=.TRUE., &
        & long_name=trim(title))
    call Put_Attr(var, "gt_structure_class", "axis")
    call Put_Attr(var, "gt_axis_vertical", axis%vertical)

    ! }̃oɂȂĂ̂̏o
    call Inquire(axis%var, url=url)
    call add_member(var, url, link_name="data")
    
    call Close(var)
    print *, trim(title), " stored at ", trim(vname)
    axis%saved = vname
    if (present(name_result)) name_result = vname
end subroutine
