#!/bin/sh

set -e

test ! -f xzonal.nc || rm -f xzonal.nc

../gtavg/gtavg dim=lon out=xzonal.nc@foo ../gtview/gtool.nc

ncdump xzonal.nc > xzonal.cdl

diff xzonal.cdl - <<END_OF_CDL
netcdf xzonal {
dimensions:
	lat = 64 ;
	time = 1 ;
variables:
	float lat(lat) ;
		lat:unit = "degree_north" ;
		lat:units = "degree_north" ;
	int time(time) ;
	float foo(time, lat) ;
		foo:long_name = "surface pressure" ;
		foo:units = "mb" ;
		foo:missing_value = -999.f ;

// global attributes:
		:Conventions = "http://www.gfd-dennou.org/arch/gtool4/conventions/" ;
		:gt_version = "4.0beta9" ;
		:source = "gt3conv (GTOOL3 DSET=A4)" ;
		:title = "surface pressure" ;
		:institution = "toyoda" ;
		:history = "19991124  24330 gatm107> (GTOOL3 creation)\n",
    "19991204 234300 toyoda> [GTOOL3 last modify; edit=TM(850.DAY-), TM(900.DAY-)]\n",
    "2000-04-12T09:09:10+09:00 toyoda> gt3conv" ;
data:

 lat = 87.8638, 85.09653, 82.31291, 79.5256, 76.7369, 73.94751, 71.15775, 
    68.36775, 65.57761, 62.78735, 59.99702, 57.20663, 54.4162, 51.62573, 
    48.83524, 46.04472, 43.25419, 40.46365, 37.67309, 34.88252, 32.09194, 
    29.30136, 26.51077, 23.72017, 20.92957, 18.13897, 15.34836, 12.55776, 
    9.767145, 6.976533, 4.185921, 1.395307, -1.395307, -4.185921, -6.976533, 
    -9.767145, -12.55776, -15.34836, -18.13897, -20.92957, -23.72017, 
    -26.51077, -29.30136, -32.09194, -34.88252, -37.67309, -40.46365, 
    -43.25419, -46.04472, -48.83524, -51.62573, -54.4162, -57.20663, 
    -59.99702, -62.78735, -65.57761, -68.36775, -71.15775, -73.94751, 
    -76.7369, -79.5256, -82.31291, -85.09653, -87.8638 ;

 time = 2664000 ;

 foo =
  955.9703, 956.1371, 956.5514, 957.2868, 958.3784, 959.9438, 962.2067, 
    965.3514, 969.4154, 974.2819, 979.6841, 985.2756, 990.7654, 995.9412, 
    1000.6, 1004.56, 1007.722, 1010.066, 1011.637, 1012.5, 1012.718, 
    1012.355, 1011.516, 1010.337, 1008.944, 1007.463, 1006.031, 1004.745, 
    1003.665, 1002.9, 1002.549, 1002.489, 1002.487, 1002.548, 1002.906, 
    1003.667, 1004.74, 1006.032, 1007.479, 1008.97, 1010.378, 1011.585, 
    1012.437, 1012.762, 1012.443, 1011.419, 1009.658, 1007.164, 1003.956, 
    1000.038, 995.4916, 990.538, 985.3998, 980.1891, 975.0588, 970.306, 
    966.1963, 962.8213, 960.1648, 958.1725, 956.7624, 955.8511, 955.3512, 
    955.1418 ;
}
END_OF_CDL

rm -f xzonal.nc xzonal.cdl

echo okay
