#!/bin/sh
# test of gtattr

set -e

ncgen -b - <<EOF
netcdf a10 {
dimensions:
	x = 12;
variables:
	float	a(x);
data:
	a = -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0;
}
EOF

test ! -f x.nc || rm -f x.nc
../gtunary/gtunary in=a10.nc?a out=x.nc?a negate
ncdump x.nc > x.cdl

diff x.cdl - <<EOF
netcdf x {
dimensions:
	dim1 = 12 ;
variables:
	float dim1(dim1) ;
	float a(dim1) ;
data:

 dim1 = 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ;

 a = 1, -0, -1, -2, -3, -4, -5, -6, -7, -8, -9, -10 ;
}
EOF

test ! -f x.nc || rm -f x.nc
../gtunary/gtunary in=a10.nc?a out=x.nc?a sqrt
ncdump x.nc > x.cdl

diff x.cdl - <<EOF
netcdf x {
dimensions:
	dim1 = 12 ;
variables:
	float dim1(dim1) ;
	float a(dim1) ;
data:

 dim1 = 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 ;

 a = -999000, 0, 1, 1.414214, 1.732051, 2, 2.236068, 2.44949, 2.645751, 
    2.828427, 3, 3.162278 ;
}
EOF

rm -f x.nc x.cdl a10.nc
echo okay
